
/* comment out the DEMO #define if using as a function in a program */

#define DEMO


/*
 * BoxDraw - Copyright 1992 - 1994 Edward Mulroy
 * Private and commercial use allowed
 *
 * This may be compiled as C or C++
 *
 * Version 3   - Changed from writing individual characters
 *               to using puttext() to write
 *             - Changed "draw_ptr", "dble_box" and "sngle_box"
 *               to unsigned char's so sign extension when or'ing
 *               with the color wouldn't alter the color
 *             - Allow any onscreen writing even if not in the
 *               current window
 * Version 3.1 - Corrected a typo in screenwidth/screenheight
 */

#include <conio.h>

#include "boxdraw.h"

typedef unsigned char uchar;


typedef enum
  {
  UpLeft, Horiz, UpRight, Vert, LowLeft, LowRight
  } box_index;


static uchar dble_box[]  = "\xC9\xCD\xBB\xBA\xC8\xBC"; /* "ͻȼ" */

static uchar sngle_box[] = "\xDA\xC4\xBF\xB3\xC0\xD9"; /* "Ŀ" */




/*
 * Draws a box with the corners given
 *   [x1,y1] is the upper left corner of the box
 *   [1,1] is the upper left corner of the screen
 *
 * "box_type" is 0 for a single line box, 1 for a double
 *
 * The box is drawn in the default color
 *
 * Return values:
 *
 *  0=success  -1=invalid box_type  -2=invalid co-ordinates
 *
 */
int draw_box(int x1, int y1, int x2, int y2, int box_type)
  {
  int    ixy;
  int    color;
  int    ch;
  int    line[81];
  uchar *draw_ptr;
  struct text_info ti;

  if (box_type == single_border)              /* decide on which box type */
    draw_ptr = sngle_box;                     /* array to draw with       */
  else if (box_type == double_border)
    draw_ptr = dble_box;
  else
    return -1;   /* bad box type */

  gettextinfo(&ti);
  color = ((int) ti.attribute) << 8;

  if (((x2 - x1) < 2) || ((y2 - y1) < 2) ||         /* check co-ordinates */
      (x1 < 1) || (y1 < 1) ||
      (x2 > ti.screenwidth) || (y2 > ti.screenheight))
    return -2;

                                             /* draw top and bottom lines */

  for (ixy = x2 - x1 - 1, ch = color | draw_ptr[Horiz]; ixy >= 0; ixy--)
    line[ixy] = ch;

  puttext(x1 + 1, y1, x2 - 1, y1, line);
  puttext(x1 + 1, y2, x2 - 1, y2, line);

                                                            /* draw sides */

  for (ixy = y2 - y1 - 1, ch = color | draw_ptr[Vert]; ixy >= 0; ixy--)
    line[ixy] = ch;

  puttext(x1, y1 + 1, x1, y2 - 1, line);
  puttext(x2, y1 + 1, x2, y2 - 1, line);

                                                          /* draw corners */
  ch = color | draw_ptr[UpLeft];
  puttext(x1, y1, x1, y1, &ch);

  ch = color | draw_ptr[LowLeft];
  puttext(x1, y2, x1, y2, &ch);

  ch = color | draw_ptr[UpRight];
  puttext(x2, y1, x2, y1, &ch);

  ch = color | draw_ptr[LowRight];
  puttext(x2, y2, x2, y2, &ch);

  return 0;
  }




#ifdef DEMO

int main()
  {
  int i;

  clrscr();

                 /* write the col and row numbers around one of the boxes */
  for (i = 10; i < 60; i += 10)
    {
    gotoxy(i, 1);
    putch((i / 10) + '0');
    }

  gotoxy(5,2);

  for (i = 5; i < 51; i++)
    putch((i % 10) + '0');

  for (i = 3; i <= 15; i++)
    {
    gotoxy(51, i);
    cprintf("%2d", i);
    }

  textattr(WHITE | (BLUE << 4));
  draw_box(10, 20, 70, 23, double_border);              /* draw two boxes */
  draw_box(5, 3, 50, 15, single_border);

  textattr(LIGHTGRAY);
  return 0;
  }

#endif


