/*
  Copyright (C) 1987 Piercarlo Grandi

	   NO WARRANTY

    BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY
  NO WARRANTY, TO THE EXTEND PERMITTED BY APPLICABLE STATE LAW.
  EXCEPT WHEN OTHERWISE STATED IN WRITING, PIERCARLO GRANDI AND/OR
  OTHER PARTIES PROVIDE THIS PROGRAM "AS IS" WITHOUT WARRANTY
  OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY
  AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE
  DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR
  CORRECTION.

   IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL PIERCARLO
  GRANDI AND/OR ANY OTHER PARTY WHO MAY MODIFY AND REDISTRIBUTE
  THIS PROGRAM AS PERMITTED BELOW, BE LIABLE TO YOU FOR
  DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR
  OTHER SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
  USE OR INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR
  DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR
  A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) THIS
  PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
  DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.

	 GENERAL PUBLIC LICENSE TO COPY

    1. You may copy and distribute verbatim copies of this source file
  as you receive it, in any medium, provided that you conspicuously and
  appropriately publish on each copy a valid copyright notice "Copyright
  (C) 1987 Piercarlo Grandi"; and include following the
  copyright notice a verbatim copy of the above disclaimer of warranty
  and of this License.  You may charge a distribution fee for the
  physical act of transferring a copy.

    2. You may modify your copy or copies of this source file or
  any portion of it, and copy and distribute such modifications under
  the terms of Paragraph 1 above, provided that you also do the following:

      a) cause the modified files to carry prominent notices stating
      that you changed the files and the date of any change; and

      b) cause the whole of any work that you distribute or publish,
      that in whole or in part contains or is a derivative of this
      program or any part thereof, to be licensed at no charge to all
      third parties on terms identical to those contained in this
      License Agreement (except that you may choose to grant more
      extensive warranty protection to third parties, at your option).

      c) You may charge a distribution fee for the physical act of
      transferring a copy, and you may at your option offer warranty
      protection in exchange for a fee.

    3. You may copy and distribute this program or any portion of it in
  compiled, executable or object code form under the terms of Paragraphs
  1 and 2 above provided that you do the following:

      a) cause each such copy to be accompanied by the
      corresponding machine-readable source code, which must
      be distributed under the terms of Paragraphs 1 and 2 above; or,

      b) cause each such copy to be accompanied by a
      written offer, with no time limit, to give any third party
      free (except for a nominal shipping charge) a machine readable
      copy of the corresponding source code, to be distributed
      under the terms of Paragraphs 1 and 2 above; or,

      c) in the case of a recipient of this program in compiled, executable
      or object code form (without the corresponding source code) you
      shall cause copies you distribute to be accompanied by a copy
      of the written offer of source code which you received along
      with the copy you received.

    4. You may not copy, sublicense, distribute or transfer this program
  except as expressly provided under this License Agreement.  Any attempt
  otherwise to copy, sublicense, distribute or transfer this program is void and
  your rights to use the program under this License agreement shall be
  automatically terminated.  However, parties who have received computer
  software programs from you with this License Agreement will not have
  their licenses terminated so long as such parties remain in full compliance.

    5. If you wish to incorporate parts of this program into other free
  programs whose distribution conditions are different, write to me.
  There is no simple rule that can be stated here, but I will often permit
  this.  I will be guided by the two goals of preserving the free status of
  all derivatives our free software and of promoting the sharing and reuse of
  software.


  In other words, you are welcome to use, share and improve this program.
  You are forbidden to forbid anyone else to use, share and improve
  what you give them.   Help stamp out high price software !

  (The lines above adapted from The Free Software Foundation's license,
  Copyright (C) 1985 by them)
*/

static char BlockNotice[] = "@(#)Block.c	2.1 12/17/87 2.1 Copyright (C) 1987 Piercarlo Grandi";

/*
  An introduction to this program.

  This is a library of core allocation/deallocation functions,
  similar in scope to the malloc(3) functions of UNIX. This is
  (hopefully) totally machine independent, is very easily configurable
  has several optimization, and care has been taken that the most
  common case has a short path.

  Among unusual features are deallocation of unused store, minimization
  of copying when reallocation is requested, unification of the
  allocate and reallocate function, easy hiding of os dependent code in
  a couple of procedures, adaptability to 2d address machines with nearly
  optimal exploitation of segments.

  Extensive debugging and tracing have been provided. Three things remain
  to be done for a truly professional library:
  1) some functions are expanded inline (e.g. DEQUEUE) -- the installer
  ought to be able to option between this and normal procedures, for
  machines where space is tight or procedure calling is fast.
  2) statistics gathering (counts of requests by type, of free list searches,
  of collapses, sum of bytes created/deleted, etc...).
  3) separating this long (>1000 lines) files into smaller ones, with
  one or two procedures at most for each (prime candidates are a Zone.c
  file and an Area.c one).

  This library has been tested, but not truly extensively -- you will
  find a few remaining bugs.
*/

#if (!defined(BlockDEBUG))
# define BlockDEBUG		0
#endif

#if (!defined(BlockPRINT))
# define BlockPRINT		0
#endif

#if (BlockDEBUG)
# define static
# undef BlockPRINT
# define BlockPRINT		1
#endif

#include "assert.h"
#if (BlockPRINT)
# include "stdio.h"
#endif

/*
  Following Dijkstra -- elseless if (post is pre negated).
    example: were (i < 0) i = -i;

  NB: in the second case (condition) had better not have any side effects...
  after all the (condition) is SUPPOSED to be tested twice !

  Under ATT SV.2 the second formulation gives a spurious statement not
  reached diagnostic at compile time if the body of the were is a return.
*/
#if (defined(NDEBUG))
# define were(condition)	if (!(condition)) skip; else
#else
# define were(condition)	for (; (condition); (condition) && abort())
#endif

/*
  If you define a macro as {} block, you will not be able to put
  a semicolon after its invocation, if that is the then part of an if.
  Use instead these two and you will be home safe.
*/
#define begindef	if (1) {
#define enddef		} else

/*
  To conserve columns in declarations, else things
  like register struct StructName are too long.
*/
#define reg		register

#define skip		/* null statement */

#define Bit2TO(n)	(1<<(n))
#define BitMODULUS(i,n)	((i) & ((1<<(n))-1))
#define BitROUNDUP(i,n)	(1 + (((1<<(n))-1)|((i)-1)))

#if (defined(iAPX286))
# define CoreCOPY(from,to,bytes)	memcpy((to),(from),(bytes))
#endif

/*
  This set of definitions allows any program to be fully addressing
  strategy independent: addressing is expected to be bidimensional;
  each address has two fields (they need not have any special place
  in the address, not even contiguous), one identified a segment,
  the other an offset within it. Arithmetic can only be done on the
  offset portion, and the id portion does not take place in it.

  On monodimensional address machines we use the very same definitions,
  but the id portion is in effect missing from an address, so we
  fake it as always being 0, and the offset actually takes up all bits
  in the address (unless of course it is a 370 or a MC68010 or such
  that use only 24 of their 32 address bytes or such).

  Mnemonic rule for X,Y : X is the segment indeX number,
  and Y is the bYte number.
*/

#if (defined(iAPX286))
  typedef char		*Ptr;			/* Generic pointer	*/
# define PtrNIL		((Ptr) 0)		/* Distinguished pointer*/

# if (defined(LARGE_M))
    typedef long unsigned	PtrW;		/* Pointer as binary word*/
#   define PtrBITS		32		/* Bits in pointer	*/

    typedef short unsigned 	PtrX;		/* Row or segment number*/
    typedef short unsigned  	PtrY;		/* Column or byte number*/
#   define PtrXBITS		16
#   define PtrYBITS		16

#   define PtrTO(x,y)		((Ptr) (((PtrW) (x) << PtrYBITS) | (y)))
#   define PtrXOF(ptr)		((PtrX) (((PtrW) (ptr)) >> PtrYBITS))
#   define PtrYOF(ptr)		((PtrY) (PtrW) (ptr))
#   if (defined(undef)) /* lvalue X and Y -- highly questionable */
#     define PtrXIN(ptr)	(((PtrX *) &(ptr))[1])
#     define PtrYIN(ptr)	(((PtrY *) &(ptr))[0])
#   endif
# endif

# if (defined(SMALL_M))
    typedef short unsigned	PtrW;		/* Pointer as binary word*/
#   define PtrBITS		16		/* Bits in pointer	*/

    typedef short unsigned 	PtrX;		/* Row or segment number*/
    typedef short unsigned  	PtrY;		/* Column or byte number*/
#   define PtrXBITS		0
#   define PtrYBITS		16

#   define PtrTO(y,x)		((Ptr) (x)))
#   define PtrXOF(ptr)		((PtrX) 0))
#   define PtrYOF(ptr)		((PtrY) (ptr))
#   if (defined(undef)) /* lvalue X and Y -- highly questionable */
      PtrX			PtrXDummy;	/* Fakes assignments	*/
#     define PtrXIN(ptr)	PtrXDummy
#     define PtrYIN(ptr)	(((PtrY *) &(ptr))[0])
#   endif
# endif

#endif

/*
  Given a pointer to a field of a the specified structure type, returns
  the address of the whole structure instance. Very useful for having
  records linked in more than one list or tree, or where the link cannot
  be the first field in a struct.

  NB: This definition is "perfectly" portable.
*/
#define structof(ptr,struct,field) \
  ((struct *) ((PtrW) ((Ptr) (ptr)) - (PtrY) &((struct *) 0)->field))

/*
  GRANULE is the granularity of allocation, all blocks returned must
  be multiple of this size (and their address too).

  EXTEND is the minimum extension to the break we request; what remains
  having satisfied the current request is left free. If the current request
  is smaller than KEEPIT then the GRANULE is divided not into 1 busy
  block and 1 free block but into n+1 busy blocks, of which n go onto
  the keeplist for that size (until n becomes equal to MAXKEPT), and
  the remainder of the granule is left free.

  RELEASE, if defined, is the minimum amount of free memory to release
  to the operating system by bringing down the break.

  TRYLOWER and TRYHIGHER are flags that control the work of Create when
  it must resize a block, and the new size is greater than the current
  size. With TRYLOWER Create will collapse it to the lower block if free
  and useful, and with TRYHIGHER will do the same with the higher block.
  If both are defined, both lower and higher blocks will be collapsed into
  the current block if this creates a new block of sufficient size.

  RELEASE, TRYLOWER, and TRYHIGHER have been provided so that it is possible
  to exclude from compilation seldom used sections of code, to make it
  smaller.
*/

#if (!defined(BlockGRANULE))
# define BlockGRANULE	2		/* Base 2 logarithm		*/
#endif

#if (!defined(ZoneEXTEND))
# define ZoneEXTEND	2048		/* Multiple of 2^GRANULE	*/
#endif
#if (!defined(ZoneRELEASE))
# define ZoneRELEASE	4096		/* Multiple of 2^GRANULE	*/
#endif

#if (!defined(BlockTRYLOWER))
# define BlockTRYLOWER	1		/* Boolean			*/
#endif
#if (!defined(BlockTRYHIGHER))
# define BlockTRYHIGHER	1		/* Boolean			*/
#endif

/*
  Each block is linked in one or two lists. All blocks are lonked in
  and ascending memory address list; free blocks are also linked in
  one free list. Both lists are doubly linked.

  The ascending memory, fundamental, list links are contained in the
  first two fields of a block, as the address of the previous block,
  and the size of the current; macros exist to compute the address
  of the next block. The size is guranteed to be a multiple of some
  power of two, so that the lower bits of the size field ought to be
  always zero. We use the least significant bit to distinguish between
  busy and free blocks.

  The body of a block contains a minimum of (1<<SMALL) bytes, or
  the free list two links if the block is free.
*/

#if (BlockGRANULE < 1)
# include "ERROR: block addresses must be multiples of 2 for flagging"
#endif

/*
  Notice that the free list links are full pointers, because the
  free list is the same for all segments.
*/
struct BlockFree
{
  struct BlockHead	  *BfBefore;
  struct BlockHead	  *BfAfter;
};

#define BlockNIL	((struct BlockHead *) PtrNIL)

/*
  Notice that the "pointers" to contiguous blocks are just the
  in segment byte offset, as blocks in different segment cannot
  be collapsed together, i.e., they are not contiguous by definition.
*/
struct BlockHead
{
  PtrY			  BhLower;
  PtrY			  BhHigher;
#define			    BlockBUSY	((PtrY) 1)
#define			    BlockHIGH	(~ (PtrY) 1)
  union BlockBody
  {
    long unsigned	    BbData;
    struct BlockFree	    BbLink;
  }			  BhBody;
# define BhBODY		    BhBody.BbData
# define BhFIRST	    BhBody.BbFirst
# define BhBEFORE	    BhBody.BbLink.BfBefore
# define BhAFTER	    BhBody.BbLink.BfAfter
};

#define BlockSMALL	(sizeof (struct BlockHead))
#define BlockEXTRA	(sizeof (struct BlockHead) - sizeof (union BlockBody))

#define BlockISFREE(block)	(((block)->BhHigher & BlockBUSY) != BlockBUSY)

#define BlockSIZE(block)	(((block)->BhHigher&BlockHIGH) - PtrYOF(block))
#define BlockFSIZE(block)	((block)->BhHigher - PtrYOF(block))

#define BlockLOWER(block) \
  ((struct BlockHead *) PtrTO(PtrXOF(block),(block)->BhLower))
#define BlockHIGHER(block) \
  ((struct BlockHead *) PtrTO(PtrXOF(block),(block)->BhHigher&BlockHIGH))
#define BlockFHIGHER(block) \
  ((struct BlockHead *) PtrTO(PtrXOF(block),(block)->BhHigher))

/*
  Collapse two contiguous blocks on the ascending address list into one,
  the lower one (of course...). Both blocks are assumed to be free...
*/

#define BlockCOLLAPSE(lower,higher)					\
begindef								\
  assert(BlockISFREE(lower));						\
  assert(BlockISFREE(higher));						\
  BlockFHIGHER(higher)->BhLower = PtrYOF(lower);			\
  (lower)->BhHigher = (higher)->BhHigher;				\
enddef

/*
  We define an interator on a free list queue.
*/

#define forqueue(head,queue,condition)					\
  for									\
  (									\
    (head) = (queue)->BhAFTER;						\
    (head) != (queue) && (condition);					\
    (head) = (head)->BhAFTER						\
  )

/*
  Append a block into a free list, or remove it.

  We reset the BlockHand to the most recently queued block, to
  make it more probable that it will be the next to be considered
  for allocation, to conserve locality of reference. Probably a
  purely sequential movement of the BlockHand is better to contain
  fragmentation...
*/

#define BlockENQUEUE(list,block)					\
begindef								\
  assert(BlockISFREE(block));						\
  assert((list)->BhAFTER != BlockNIL && (list)->BhBEFORE != BlockNIL);	\
  BlockHand		= (block);					\
  (block)->BhBEFORE	= (list);					\
  (block)->BhAFTER	= (list)->BhAFTER;				\
  (block)->BhAFTER->BhBEFORE = (block);					\
  (list)->BhAFTER	= (block);					\
enddef

#define BlockDEQUEUE(block)						\
begindef								\
  assert(BlockISFREE(block));						\
  assert((block)->BhAFTER != BlockNIL && (block)->BhBEFORE != BlockNIL);\
  if (BlockHand == (block)) BlockHand = (block)->BhAFTER;		\
  (block)->BhAFTER->BhBEFORE = (block)->BhBEFORE;			\
  (block)->BhBEFORE->BhAFTER = (block)->BhAFTER;			\
enddef

static Ptr		AreaTop = PtrNIL;

static Ptr		AreaCreate(bytes)
  PtrY		  bytes;
{
  reg Ptr		  newarea;
  extern Ptr		  sbrk();
  extern unsigned	  brk();

  were (AreaTop == PtrNIL)
  {
    reg Ptr		    thebreak;

    /*
      Why this charade ? AreaTop points not to the break, but one byte
      below it. If sbrk(0) were to return address 0 (or on 2D address
      machines the beginning of a segment), AreaTop would become -1.
      Attention to detail...
    */
    thebreak = (PtrYOF(sbrk(0)) != (PtrY) 0)
      ? sbrk(0) : sbrk(Bit2TO(BlockGRANULE)) + Bit2TO(BlockGRANULE);

    AreaTop = thebreak-1;
  }

  assert(BitMODULUS(PtrYOF(AreaTop)+1,BlockGRANULE) == 0);

  /*
    Why -512 ? Because We cannot really have a full sized segment...
    and segments are allocated in 512 bytes clicks.
  */
# if (PtrXBITS == 0)
    newarea = sbrk(bytes);
# else
#   if (defined(iAPX286))
      newarea = (bytes > (Bit2TO(PtrYBITS)-512-PtrYOF(AreaTop)))
#   else
      newarea = (bytes > (Bit2TO(PtrYBITS)-PtrYOF(AreaTop)))
#   endif
	? sbrk(bytes)
	: (brk((Ptr) AreaTop + bytes + 1) ? (Ptr) -1 : AreaTop + 1);
# endif

  were (newarea == (Ptr) -1)
    return PtrNIL;

  AreaTop = newarea + bytes - 1;

  return newarea;
}

#if (ZoneRELEASE > 0)
static Ptr		AreaDelete(from)
  reg Ptr		  from;
{
  assert(PtrXOF(AreaTop) == PtrXOF(from));

# if (BlockDEBUG)
    fprintf(stderr,"AreaDelete: AreaTop %#08lx, from %#08lx\n",AreaTop,from);
# endif

  were (brk(from) != 0)
  {
    perror("Releasing memory with brk()");
    abort();
  }

  AreaTop = from - 1;
}
#endif

static struct BlockHead	BlockList;
static struct BlockHead	*BlockHand;
static short unsigned	BlockStarted = 0;

#if (BlockPRINT)

static void		BlockHeadPrint(head)
  reg struct BlockHead	  *head;
{
  fprintf(stderr,"  HEAD %#08lx: lower %#04x, higher %#04x, %s, size %u\n",
    head,head->BhLower,head->BhHigher&BlockHIGH,
    BlockISFREE(head) ? "FREE" : "BUSY",
    (head->BhHigher > PtrYOF(head)) ? BlockSIZE(head) : 0);
}

static struct BlockHead	*BlockFirst;

static void		BlockAllPrint()
{
  reg struct BlockHead	  *head;

  for (head = BlockFirst; head->BhHigher > head->BhLower; head = BlockHIGHER(head))
    BlockHeadPrint(head);
}

static void		BlockFreePrint()
{
  reg struct BlockHead	  *head;

  fprintf(stderr,"FREE %#08lx before %#08lx, after %#08lx, hand %#08lx\n",
    &BlockList,BlockList.BhBEFORE,BlockList.BhAFTER,BlockHand);

  forqueue(head,&BlockList,1)
    BlockHeadPrint(head);

  fputs("END FREE\n",stderr);
}
#endif

/*
  Here we allocate zones. A zone is a region of contiguous core divided
  into blocks, where the blocks are doubly linked into a list of contiguous
  ascending address blocks. In order to close this list we put at the
  end of each zone a fictitious block, size zero (so it is its own higher),
  permanently busy, whose lower is the block that covers the whole zone.

  This last block is surreptitiously addressed as the "lower" block of
  the first block in the zone, closing the list.

  When we allocate a new area of core to turn into a zone, we check
  whether the new area comes just at the end of the previously allocated
  one; if so, we merge the zones.
*/

static struct BlockHead	*ZoneLast = BlockNIL;

static struct BlockHead	*ZoneCreate(size)
  PtrY		  size;
{
  reg struct BlockHead	  *new;
  reg struct BlockHead	  *first;
  reg struct BlockHead	  *newlast;

  {
    reg Ptr		    area;
    reg struct BlockHead    *oldlast;

    area = PtrNIL;

  PaddedZone:
    were (size < ZoneEXTEND &&
        (area = AreaCreate(ZoneEXTEND+BlockEXTRA)) != PtrNIL)
      size = ZoneEXTEND;

  PreciseFitZone:
    were (area == PtrNIL)
    {
      area = AreaCreate(size + BlockEXTRA);
      were (area == PtrNIL)
	return BlockNIL;
    }

  NewLastAtEnd:
    newlast = (struct BlockHead *) (area+size);

    were (ZoneLast == BlockNIL)
      ZoneLast = newlast;

    oldlast = ZoneLast;

#   if (BlockDEBUG)
      fprintf(stderr,"\nZoneCreate: area %#08lx, newlast %#08lx oldlast\n",
	area,newlast);
      BlockHeadPrint(oldlast);
#   endif

    /*
      Now we have got the storage, we must organize it. A zone has two
      distinguished headers, the first and the last. The first is the header
      of a normal block, except that is BhLower actually points higher,
      the the last. The last is an header without a body, and its BhHigher
      points lower to the first. In between there is a theory of headers
      with their blocks, chained as usual.

      A zone is correctly set up when the above situation is true, so
      we only have to establish it. The newly allocated storage has
      to be set up as a new block just under the last.

      We only have to determine three pointers then: that to the first
      block, to the last block (which is fixed), and to the new block.

      In order to collapse zones together, we check whether the new zone
      sits just above the last of the previously allocate one. If this is
      true, the first is that of the old zone, the new is either the previous
      zone last (to recover its space) or the block before that if free;
      if this is not true, the first and new coincide in the beginning
      of the newly allocated zone.
    */

  DetermineFirstAndNew:
    if (((Ptr) oldlast + BlockEXTRA) != area)
      first = new = (struct BlockHead *) area;
    else
    {
      /*
	Notice that first == new == oldlast may be true, and later on we
	test whether new is free. Resist the temptation to take off BUSY
        from oldlast so that we can use FHIGHER.
      */
      first = BlockHIGHER(oldlast);
      new = BlockLOWER(oldlast);

      if (BlockISFREE(new))
	BlockDEQUEUE(new);
      else
	new = oldlast;
    }
  }

LinkFirstWithLast:
  first->BhLower	= PtrYOF(newlast);
  newlast->BhHigher	= PtrYOF(first)|BlockBUSY;

LinkNewUnderLast:
  new->BhHigher		= PtrYOF(newlast);
  newlast->BhLower	= PtrYOF(new);

# if (BlockDEBUG)
    BlockHeadPrint(new);
    fputs("\n",stderr);
# endif

  ZoneLast = newlast;

  assert(BlockHIGHER(ZoneLast) == first && BlockLOWER(first) == ZoneLast);
  assert(BlockLOWER(ZoneLast) == new
    && BlockISFREE(new) && BlockFHIGHER(new) == ZoneLast);

  return new;
}

#if (ZoneRELEASE > 0)
static void		ZoneDelete(newlast)
  reg struct BlockHead	  *newlast;
{
  reg struct BlockHead	  *oldlast;

  assert(BlockFHIGHER(newlast) == ZoneLast && BlockFSIZE(newlast) >= ZoneRELEASE);

NewlastBecomesZoneLast:
  oldlast = ZoneLast;
  ZoneLast = newlast;

# if (BlockDEBUG)
    fprintf(stderr,"ZoneDelete: first, block, oldlast\n");
    BlockHeadPrint(BlockHIGHER(oldlast));
    BlockHeadPrint(newlast);
    BlockHeadPrint(oldlast);
# endif

LinkFirstAndNewLast:
  BlockHIGHER(oldlast)->BhLower = oldlast->BhLower;
  newlast->BhHigher = oldlast->BhHigher;

# if (BlockDEBUG)
    fprintf(stderr,"  first, newlast\n");
    BlockHeadPrint(BlockHIGHER(oldlast));
    BlockHeadPrint(newlast);
# endif

DeleteNewlastBody:
  AreaDelete((Ptr) &(newlast->BhBODY));
}
#endif


static void		BlockStartup()
{
  /*
    Tricky! having size == 0 means that BlockAFTER(&BlockList) is
    identically equal to &BlockList, that is exactly what we want.
    Notice that this cannot be really 0, because sizeof BlockList
    ain't zero, but we can take licences here and there...
  */

  BlockList.BhHigher = BlockList.BhLower = PtrYOF(&BlockList);
  BlockList.BhAFTER = BlockList.BhBEFORE = &BlockList;

  BlockHand = &BlockList;

  BlockStarted = 1;

# if (BlockDEBUG)
    fputs("\nBlockStartup:\n",stderr);
    BlockFreePrint();
    fputs("\n",stderr);
# endif
}

static void		BlockDelete(block)
  reg struct BlockHead	  *block;
{
  assert(!BlockISFREE(block));

# if (BlockDEBUG)
    fputs("\n\nBlockDelete: block, free list\n",stderr);
    BlockHeadPrint(block);
    BlockFreePrint();
# endif

  block->BhHigher &= BlockHIGH;

  {
    reg struct BlockHead   *nearest;

    nearest = BlockFHIGHER(block);
#   if (BlockDEBUG)
      fprintf(stderr,"  higher %#08lx\n",nearest);
      BlockHeadPrint(nearest);
#   endif
    if (BlockISFREE(nearest))
    {
      BlockDEQUEUE(nearest);
      BlockCOLLAPSE(block,nearest);
    }

    nearest = BlockLOWER(block);
#   if (BlockDEBUG)
      fprintf(stderr,"  lower %#08lx\n",nearest);
      BlockHeadPrint(nearest);
#   endif
    if (BlockISFREE(nearest))
    {
      BlockDEQUEUE(nearest);
      BlockCOLLAPSE(nearest,block);
      block = nearest;
    }
  }

  /*
    Before putting it back onto the free list, we check if this the
    last block in memory and whether it is "large"; if so, the zone is
    contracted, freeing up storage. The following test deals with
    "Zone" variables about which "Block" ought to know anything;
    The test ought to be in ZoneDelete(), thus, but we can save
    a procedure call in the most common case...
  */
# if (ZoneRELEASE > 0)
    if (BlockFHIGHER(block) == ZoneLast && BlockFSIZE(block) >= ZoneRELEASE)
      ZoneDelete(block);
    else
# endif
      BlockENQUEUE(&BlockList,block);

# if (BlockDEBUG)
  fputs("BlockDelete: at end\n",stderr);
  BlockFreePrint();
  fputs("\n",stderr);
#endif
}

static struct BlockHead	*BlockCreate(old,bytes)
  reg struct BlockHead	  *old;
  reg PtrY		  bytes;
{
  reg struct BlockHead	  *new;
  reg PtrY		  newsize;

InitializeGlobals:
  were (!BlockStarted)
    BlockStartup();

IncludeHeadInSize:
  newsize = BlockEXTRA + bytes;

# if (BlockDEBUG)
    fprintf(stderr,"\n\nBlockCreate: bytes %u, size %u",bytes,newsize);
#endif

RoundAndPadSize:

  were (BitMODULUS(newsize,BlockGRANULE) != 0)
    newsize = BitROUNDUP(newsize,BlockGRANULE);

  were (newsize < BlockSMALL)
    newsize = BlockSMALL;

# if (BlockDEBUG)
    fprintf(stderr,", rounded size %u\n",newsize);
# endif

  /*
    Now for our logic. The old block may or may not exist. In any
    case in order to resize it we must find a new block of the
    new desired size or large and then pare it down to the requested
    size if larger.

    Finding a new block if an old one exists, has two special cases:
    If the old block is larger than the new size, we do nothing, as
    it is the block we are looking for. If the old is smaller, we
    check whether the block higher than it is free, and whether their
    combined sizes are sufficient. If so, the higher is detached from
    the free list and then they are just collapsed. If not, we look at
    the lower block and do the same.

    At this point if we have not found a suitable new block yet, we
    allocate a new one searching in the free list or creating a new zone.

    Finally, if the old block existed, and the new is not at the
    same address, we copy the body of the old block to the new, which
    is marked busy, and it's body address returned.

  */

HasToBeFound:
  new = BlockNIL;

TryReuseOld:
  if (old != BlockNIL)
  {
    reg PtrY		  oldsize;
#   if (BlockTRYLOWER)
      reg struct BlockHead  *lower = BlockLOWER(old);
#   endif
#   if (BlockTRYLOWER)
      reg struct BlockHead  *higher = BlockFHIGHER(old);
#   endif

  OldConsideredFree:
    old->BhHigher &= BlockHIGH;
    oldsize = BlockFSIZE(old);

#   if (BlockDEBUG)
      fprintf(stderr,"old %#08lx, lower,higher\n",old);
#   if (BlockTRYLOWER)
      BlockHeadPrint(lower);
#   endif
#   if (BlockTRYLOWER)
      BlockHeadPrint(higher);
#   endif
#   endif

    /*
      If this has any success, old will transform itself into new,
      and old will no longer have meaning.
      If one of the two lower and higher bring the size to be greater
      than the requested one, we collapse only higher, to avoid copying
      down the contents of the block; if both are needed, we collapse
      both with old.
    */

#   if (BlockTRYHIGHER)
      if (oldsize < newsize && BlockISFREE(higher) &&
	(oldsize+BlockFSIZE(higher)) >= newsize
#	if (BlockTRYLOWER)
	  || (BlockISFREE(lower) &&
	      (BlockFSIZE(lower)+oldsize+BlockFSIZE(higher)) >= newsize)
#       endif
      )
      {
      AppendHigherToOld:
	BlockDEQUEUE(higher);
	BlockCOLLAPSE(old,higher);
	oldsize = BlockFSIZE(old);
      }
#   endif
      
#   if (BlockTRYLOWER)
      if (oldsize < newsize && BlockISFREE(lower) &&
	(BlockFSIZE(lower)+oldsize) >= newsize
      )
      {
      PrependLowerCopyAndOldDisappears:
	BlockDEQUEUE(lower);
	BlockCOLLAPSE(lower,old);
	CoreCOPY((Ptr) &(old->BhBODY),(Ptr) &(lower->BhBODY),oldsize);
	old = lower; oldsize = BlockFSIZE(old);
      }
#   endif

    if (oldsize >= newsize)
    {
      new = old;
      old = BlockNIL;
    }
  }

MustAllocateNew:
  if (new == BlockNIL)
  {
# if (BlockDEBUG)
    BlockFreePrint();
    fprintf(stderr,"  searching:\n");
#   endif


  TryToFind:
    forqueue(new,BlockHand,BlockFSIZE(new) < newsize)
#   if (BlockDEBUG)
      BlockHeadPrint(new);
#   else
      skip;
#   endif

    if (new != &BlockList && BlockFSIZE(new) >= newsize)
      BlockDEQUEUE(new);
    else
    {
    TryCreateStorage:
      new = ZoneCreate(newsize);
      were (new == BlockNIL)
        return BlockNIL;
    }

 MayCopyOldAndDeleteIt:
    if (old != BlockNIL)
    {
      CoreCOPY((Ptr) &(old->BhBODY),(Ptr) &(new->BhBODY),BlockFSIZE(old));
      /*
        Tricky Dick ! BlockDelete will check for neighbouring blocks
        to be free for collapsing, and nobody forbids new to be one
        of those. We temporarily mark it busy, then free it again.
      */
      new->BhHigher |= BlockBUSY;
      old->BhHigher |= BlockBUSY; BlockDelete(old); old = BlockNIL;
      new->BhHigher &= BlockHIGH;
    
    }
  }

  /*
    At this point, either old recycled or newly allocated, new is
    ready to be returned, and old has lost any meaning. Note however
    that new may be larger than requested; if the excess part is not
    too small we cut it away and refree it.
  */

MaybeTooLarge:
  {
    reg PtrY		    actualsize;
    reg PtrY		    restsize;

    if ((actualsize = BlockFSIZE(new)) == newsize
	|| (restsize = actualsize-newsize) <= BlockSMALL)
      new->BhHigher |= BlockBUSY;
    else
    {
      reg struct BlockHead *rest;

    SplitNew:
      new->BhHigher	= PtrYOF(new) + newsize;
      rest 		= BlockFHIGHER(new);
      rest->BhLower	= PtrYOF(new);
      rest->BhHigher	= PtrYOF(rest) + restsize;
      BlockFHIGHER(rest)->BhLower = PtrYOF(rest);

#     if (BlockDEBUG)
        fprintf(stderr,"rest %#08lx size %u\n",rest,BlockFSIZE(rest));
        BlockHeadPrint(rest);
#     endif

      /*
        We must mark new busy before deleting rest otherwise BlockDelete
        will collapse rest again with new...
      */
      new->BhHigher |= BlockBUSY;

      rest->BhHigher |= BlockBUSY; BlockDelete(rest); /* rest = BlockNIL; */
    }
  }

# if (BlockDEBUG)
    fputs("BlockCreate: at end\n",stderr);
    BlockHeadPrint(new);
    fputs("\n",stderr);
# endif

  return new;
}
#if (defined(iAPX286))
# include <malloc.h>
#endif

char			*malloc(bytes)
  register unsigned	  bytes;
{
  return (char *) &BlockCreate(BlockNIL,(PtrY) (bytes))->BhBODY;
}

/*
  Allocating a row of n objects each bytes long is different from
  allocating a single block of n*bytes size only when each object's
  bytes does not include padding or alignment, so that there is unused
  space between each element of the row. Example: if sizeof of the
  struct s {short int i; char c;} is 3, but the machine requires
  aligned data references, an array of 10 struct s will be 40 bytes
  long, not 30. Most compilers will tell you that sizeof (struct s) is
  4, though, if the machine requires aligned data references...
  Use the following (portable) program to see what happens on your machine:

    struct s1 { short int i; char c; }	a1[10];
    struct s2 { long float f; char c; }	a2[10];

    main()
    {
      printf("sizeof: s1 x 1 = %lu, s1 x 10 = %lu\n",
	(long unsigned) sizeof (struct s1),(long unsigned) sizeof a1);

      printf("sizeof: s2 x 1 = %lu, s2 x 10 = %lu\n",
	(long unsigned) sizeof (struct s2),(long unsigned) sizeof a2);
    }
*/

#if (defined(iAPX286))
  char			*calloc(n,bytes)
    register unsigned	  n;
    register unsigned	  bytes;
  {
    return (char *) BlockCreate(BlockNIL,(PtrY) (n*bytes))->BhBODY;
  }
#endif

char			*realloc(old,newbytes)
  register char		  *old;
  register unsigned	  newbytes;
{
  return (char *) BlockCreate(
    structof((union BlockBody *) (old),struct BlockHead,BhBODY),
    (PtrY) (newbytes)
  );
}

void			free(old)
  register char		  *old;
{
  BlockDelete(
    structof((union BlockBody *) (old),struct BlockHead,BhBODY)
  );
}
collapse only higher, to avoid copying
      down the contents of the bl                                      