/////////////////////////////////////////////////////////////
// vecptr.h: Vector pointer class.
// Copyright(c) 1993 Azarona Software. All rights reserved.
/////////////////////////////////////////////////////////////
#ifndef H_VECPTR
#define H_VECPTR

// NOTE: You can define ELEMENT_STRIDE to get the non-optimized
// version of the vector pointers, which don't use byte strides.

#ifndef ELEMENT_STRIDE

// This is the optimized version

template<class TYPE>
class VecPtr { 
private:
  TYPE *p;
  const unsigned stride;
public:
  VecPtr(TYPE *t, unsigned s=1)         : p(t), stride(s*sizeof(TYPE)) { }
  VecPtr(const VecPtr<TYPE> &s)         : p(s.p), stride(s.stride) { }
  void operator=(const VecPtr<TYPE> &s) { p = s.p; }
  void operator=(TYPE *t)               { p = t; }
  void operator++()                     { (char *)p += stride; }
  void operator++(int)                  { (char *)p += stride; }
  void operator+=(unsigned n)           { (char *)p += stride * n; }
  TYPE &operator[](unsigned i) const    { return *(TYPE *)((char *)p + stride*i); }
  operator TYPE *() const               { return p; }
  TYPE &operator *() const              { return *p; }
#ifdef TYPE_IS_STRUCTURE
  TYPE *operator->() const              { return p; }
#endif
};

#else

// This is the unoptimized version

template<class TYPE>
class VecPtr { 
private:
  TYPE *p;
  const unsigned stride;
public:
  VecPtr(TYPE *t, unsigned s=1)         : p(t), stride(s) { }
  VecPtr(const VecPtr<TYPE> &s)         : p(s.p), stride(s.stride) { } 
  void operator=(const VecPtr<TYPE> &s) { p = s.p; }
  void operator=(TYPE *t)               { p = t; }
  void operator++()                     { p += stride; }
  void operator++(int)                  { p += stride; }
  void operator+=(unsigned n)           { p += stride * n; }
  TYPE &operator[](unsigned i) const    { return p[stride*i]; }
  operator TYPE *() const               { return p; }
  TYPE &operator *() const              { return *p; }
#ifdef TYPE_IS_STRUCTURE
  TYPE *operator->() const              { return p; }
#endif
};

#endif

#endif
