////////////////////////////////////////////////////////////////
// tstvec2.cpp: Vector test program using struct elements.
// Copyright(c) 1993 Azarona Software. All rights reserved.
////////////////////////////////////////////////////////////////
#include <iostream.h>
#include "vector.h"
#include "shape.h"

template<class TYPE>
void PrtVec(const Vector<TYPE> &v)
// Print out the elements of a vector
{
  VecPtr<const TYPE> cursor(v.PtrToAll());
  unsigned i, len = v.Length();
  for (i = 0; i<len; i++) {
      cout << *cursor << ' ';
      cursor++;
  }
  cout << '\n';
}

// You need one of these statements for each type of vector:

INITNULLVEC(Shape);

// A low-level C array we'll copy

const int arr_size = 7;
Shape arr[arr_size] = {
  Shape(0,0), Shape(1,1), Shape(2,2), Shape(3,3),
  Shape(4,4), Shape(5,5), Shape(6,6)
};

void test()
{
  cout << "Creating a vector\n";

  Vector<Shape> myvec(arr_size, arr);
  cout << "myvec: "; PrtVec(myvec);

  cout << "Creating a shared slice of every other element\n";

  Vector<Shape> everyother(myvec, SHARED, 4, 2);
  cout << "everyother: "; PrtVec(everyother);

  cout << "Setting each element in slice to Shape(99,99)\n";

  everyother = Shape(99, 99);
  cout << "myvec: ";   PrtVec(myvec);
  cout << "everyother: "; PrtVec(everyother);

  cout << "Testing consistency checks for stride, length, and offset\n";

  everyother[0] = Shape(101, 101);
  everyother[1] = Shape(202, 202);
  everyother[2] = Shape(303, 303);
  everyother[3] = Shape(404, 404);

  Vector<Shape> tstslice(everyother, SHARED, 4, 2, 1);

  tstslice[0] = Shape(111, 111);
  tstslice[1] = Shape(222, 222);

  cout << "everyother:  "; PrtVec(everyother);
  cout << "tstslice: "; PrtVec(tstslice);

}

#include "tstmain.cpp"
