////////////////////////////////////////////////////////////
// shape.cpp: Methods for the shape class.
// Copyright(c) 1993 Azarona Software. All rights reserved. 
////////////////////////////////////////////////////////////
#include "shape.h"

int Shape::objects_needing_destruction = 0;
int Shape::verbose = 1; // ctor/dtor message control

Shape::Shape()
{
  x = 0; y = 0;
  if (verbose) cout << "Default Shape constructor called\n";
  objects_needing_destruction++;
}

Shape::Shape(const Shape &p)
{
  x = p.x; y = p.y;
  if (verbose) cout << "Shape copy constructor called\n";
  objects_needing_destruction++;
}

Shape::Shape(int xx, int yy)
{
  x = xx; y = yy;
  if (verbose) cout << "General Shape constructor called\n";
  objects_needing_destruction++;
}

Shape::~Shape()
{
  if (verbose) cout << "Shape destructor called\n";
  objects_needing_destruction--;
}

Shape &Shape::operator=(const Shape &p)
{
  x = p.x; y = p.y;
  if (verbose) cout << "Shape assignment called\n";
  return *this;
}

int operator==(const Shape &a, const Shape &b)
// FRIEND function. Returns 1 if data members
// are the same, else 0.
{
  return a.x == b.x && a.y == b.y;
}

int operator<(const Shape &a, const Shape &b)
// FRIEND function. Returns a 1 if distance of
// a from origin is less than b's distance.
{
  return a.x*a.x + a.y*a.y < b.x*b.x + b.y*b.y;
}

int operator>(const Shape &a, const Shape &b)
// FRIEND function. Returns a 1 if distance of
// a from origin is less than b's distance.
{
  return a.x*a.x + a.y*a.y > b.x*b.x + b.y*b.y;
}

ostream &Shape::Print(ostream &os) const
{
  return os << *this;
}

ostream &operator<<(ostream &os, const Shape &p)
{
  return os << '(' << p.x << ',' << p.y << ')';
}


Circle::Circle()
{
  r = 0;
  if (verbose) cout << "Default Circle constructor called\n";
  objects_needing_destruction++;
}

Circle::Circle(const Circle &p)
: Shape(p)
{
  r = p.r;
  if (verbose) cout << "Circle copy constructor called\n";
  objects_needing_destruction++;
}

Circle::Circle(int xx, int yy, int rr)
: Shape(xx, yy)
{
  r = rr;
  if (verbose) cout << "Parameterized Circle constructor called\n";
  objects_needing_destruction++;
}

Circle::~Circle()
{
  if (verbose) cout << "Circle destructor called\n";
  objects_needing_destruction--;
}

Circle &Circle::operator=(const Circle &p)
{
  x = p.x; y = p.y; r = p.r;
  if (verbose) cout << "Circle assignment called\n";
  return *this;
}

int operator==(const Circle &a, const Circle &b)
// FRIEND function. Returns 1 if data members
// are the same, else 0.
{
  return a.x == b.x && a.y == b.y && a.r == b.r;
}


ostream &Circle::Print(ostream &os) const
{
  return os << *this;
}

ostream &operator<<(ostream &os, const Circle &p)
{
  return os << '(' << p.x << ',' << p.y << ',' << p.r << ')';
}
