////////////////////////////////////////////////////////////
// shape.h: A class used for testing.
// *** Modified from book code, to take out reference
//     counts. (Not needed for our tests here.) ***
// Copyright(c) 1993 Azarona Software. All rights reserved. 
////////////////////////////////////////////////////////////
#ifndef H_SHAPE
#define H_SHAPE
#include <iostream.h>


struct Shape {
  static int objects_needing_destruction, verbose;
  int x, y;
  Shape();
  Shape(const Shape &p);
  Shape(int xx, int yy);
  virtual ~Shape();
  Shape &operator=(const Shape &p);
  friend int operator==(const Shape &a, const Shape &b);
  friend int operator<(const Shape &a, const Shape &b);
  friend int operator>(const Shape &a, const Shape &b);
  virtual ostream &Print(ostream &os) const;
  virtual int Area() const { return 0; }
};

struct Circle : public Shape {
  int r;
  Circle();
  Circle(const Circle &c);
  Circle(int xx, int yy, int rr);
  virtual ~Circle();
  Circle &operator=(const Circle &c);
  friend int operator==(const Circle &a, const Circle &b);
  virtual ostream &Print(ostream &os) const;
  virtual int Area() const { return 3 * r * r; }
};

ostream &operator<<(ostream &os, const Shape &p);
ostream &operator<<(ostream &os, const Circle &c);

#endif
