////////////////////////////////////////////////////////////
// range.h: Header for subscript range checking
// Copyright(c) 1993 Azarona Software. All rights reserved.
////////////////////////////////////////////////////////////

#ifndef H_RANGE
#define H_RANGE

// Code to allow easy enabling/disabling of 
// subscript checking

#ifdef NO_RANGE_CHECK
#define CHECK(i) i
#define CHECKROW(i) i
#define CHECKCOL(i) i
#else
#define CHECK(i) CheckIndx(i)
#define CHECKROW(i) CheckRow(i)
#define CHECKCOL(i) CheckCol(i)
#endif

extern unsigned DefaultRangeErrHandler(unsigned i, unsigned sz);
extern unsigned (*HandleRangeErr)(unsigned i, unsigned sz);

#endif
