


BITSET(3)						       BITSET(3)



NAME
	bitset - a package supporting the creation and manipulation of
	bitset objects

SYNOPSIS
	#include "bitset.h"

	bitset makebitset (unsigned size)
	BOOLEAN setbit (bitset set, unsigned bit, unsigned val)
	BOOLEAN testbit (bitset set, unsigned bit)
	void clear_set (bitset set)
	void compl_set (bitset set)
	void union_set (bitset set1, bitset set2)
	void intrsct_set (bitset set1, bitset set2)
	void xor_set (bitset set1, bitset set2)
	void diff_set (bitset set1, bitset set2)
	BOOLEAN equal_sets (bitset set1, bitset set2)
	BOOLEAN in_set (bitset set1, bitset set2)

DESCRIPTION
	The bitset package is a collection of routines designed to
	support creation and manipulation of bitset objects. There are
	two public types defined to support the package: 1) a dummy
	bitset type (typedef'ed to void * in bitset.h) used to mask the
	private implemetion type, and 2) a BOOLEAN type (typedef'ed to
	int in bitset.h) used to abstract the operations that are
	inherently predicates.

	Makebitset creates a bitset object. It takes an unsigned int
	indicating the size of the bitset in bits. It returns a pointer
	to the created bitset object on success, NULL on failure.
	Initially, all bitsets are empty.

	Setbit sets or clears an individual bit in a bitset. It takes a
	pointer to the bitset to be manipulated, an unsigned int
	indicating which bit is to be set or cleared, and an unsigned
	int, the least significant bit of which specifies the value that
	the bit is to be set to. Setbit returns TRUE if the bit is
	contained in the bitset, FALSE if the bit number is out of
	range.

	Testbit tests whether an individual bit is set or clear. It
	takes a pointer to the bitset to be manipulated and an unsigned
	int indicating which bit is to be tested. It returns TRUE if the
	bit is set, FALSE if the bit is clear or the bit number is out
	of range.

	Clear_set clears the bits in a bitset. It takes a pointer to the
	bitset to be cleared.



				 [ 1 ]



BITSET(3)						       BITSET(3)



	Compl_set complements the bits in a bitset. It takes a pointer
	to the bitset to be complemented.

	Union_set forms the union of two bitsets. It takes pointers to
	the bitsets from which the union is to be formed. On return the
	bitset pointed to by set1 contains the formed union.

	Intrsct_set forms the intersection of two bitsets. It takes
	pointers to the bitsets from which the intersection is to be
	formed. On return the bitset pointed to by set1 contains the
	formed intersection.

	Xor_set forms the exclusive-or of two bitsets. It takes pointers
	to the bitsets from which the exclusive-or is to be formed. On
	return the bitset pointed to by set1 contains the exclusive-or.

	Diff_set forms the set-difference between two bitsets. It takes
	pointers to the bitsets from which the set-differnece is to be
	formed. On return the bitset pointed to by set1 contains the
	set-difference.

	Equal_sets determines if two bitsets are equal. It takes
	pointers to the two bitsets to be comapared and returns TRUE if
	they are equal, FALSE if they are not. Two bitsets are
	considered equal if and only if they are the same size and have
	the same bit pattern.

	In_set determines if one bitset is a subset of another. It takes
	pointers to the two bitsets to be tested and returns TRUE if
	set1 is a subset of set2, FALSE if it is not. A bitset is
	considered a subset of another if and only if it is no larger
	than and all of its bits that are set are also set in the bitset
	it is being compared to.

	Operation routines that take more than one bitset pointer as
	parameters will accept pointers to bitsets of different sizes.
	The operation is applied only to the portion of the larger that
	overlaps the smaller.

	While the routine makebitset() must be used to create bitset
	objects, the standard library routine free() may be used to
	de-allocate them.

AUTHOR
	Richard Hargrove
	Texas Instruments, Inc.
	P.O. Box 869305, m/s 8473
	Plano, TX 75086
	214/575-4128



				 [ 2 ]

