
/*	bitset.h	include file to support the bitset package
 */

typedef void *bitset;			/* abstracted type which hides the */
					/* object's internal representation */

typedef int BOOLEAN;

bitset	makebitset (unsigned);			/* create a bitset */
BOOLEAN setbit (bitset, unsigned, unsigned);	/* set a bit in the bitset */
BOOLEAN testbit (bitset, unsigned); 		/* test a bit in the bitset */
void clear_set (bitset);		/* clear the bits in a bitset */
void compl_set (bitset);		/* complement the bits in a bitset */
void union_set (bitset, bitset);	/* OR the bits in two bitsets */
void intrsct_set (bitset, bitset);	/* AND the bits in two bitsets */
void xor_set (bitset, bitset);		/* XOR the bits in two bitsets */
void diff_set (bitset, bitset); 	/* DIFF the bits in two bitsets */
BOOLEAN equal_sets (bitset, bitset);	/* ret TRUE if two bitsets are equal */
BOOLEAN in_set (bitset, bitset);	/* ret TRUE if a bitset is a subset */
					/* of another */

