#include <string.h>
#include "equip.h"
// The following shows that the definitions for a sorted array
// are pretty easy
// There isn't a good example of how to do this with BC++
//
// The linking of this example relies on the Smart template generation
// which defines the template class several times but then sorts it
// out in the linking
// If you change the compile C++ options it will get in a mess
Equip::Equip()
			{
				id[0] = '\0';                       // Safety first
				description[0] = '\0';
			}
// Don't ask why, operators just look like this. Close eyes and copy
// The BIDS arrays get funny if they are not member functions

int Equip:: operator < (const Equip & test1)
			{
				if (strcmp(id,test1.id)<0)
					return 1;
				else
					return 0;
            }
int Equip::operator == (const Equip & test1)
			{
				if (strcmp(id,test1.id)==0)
					return 1;
				else
					return 0;
            }
//
// Major warning. This is a simplified example which is valid for the
// general case, but relies on the stuff in Equip having "good copy semantics"
// What that means is that C++ can do a byte copy and the Equip instance
// is successfully copied.
// If you want to store something more complicated, e.g. a class item or
// an object held by a pointer (as opposed to a pointer to say a window
// where a copy of the pointer might be sensible) then you would need
// to create a copy constructor. That looks like this in this example
// Equip::Equip(const Equip & oldEquip)
//	{
//	 	strcpy(id,oldEquip.id);
//      strcpy(description,oldEquip.description);
//	}
// In reality, this might need to do some allocation via new, and a
// destructor would also be required. My example doesn't need them as
// the storage is implicit in the char array declaration.
