#ifndef _BIDSMAIN_H
#define _BIDSMAIN_H
#include "equip.h"
// You can have headers within headers if you wish
// but this one will not get used in BIDSMAIN.CPP
// as there was already one before #include "bidsmain.h"
//

//************** Define the Main Window **************
_CLASSDEF(TMainWindow)
_CLASSDEF (TListBox)
// The above serve two purposes
// 1. To allow the use of PTMainWindow instead of TMainWindow*
// 2. When you have a pointer, C++ doesn't need to know what the
//    class looks like. This can save some circular header files
//    which get a bit tricky. Also, it can reduce re-compiles when
//    you have to change a header included in lots of places
class TMainWindow : public TWindow
{
	public:
		EquipArray  * equipment;   // a pointer to BIDS array
        PTListBox		display;   // An (OWL) pointer to a listbox

		TMainWindow(PTWindowsObject AParent, LPSTR ATitle);
		~TMainWindow();
		void SetupWindow();
		virtual void AddItem(RTMessage Msg) = [CM_FIRST + CM_ADD];
		virtual void WMSize(RTMessage Msg) = [WM_FIRST + WM_SIZE];
};
#endif