#include <owl.h>
#include <listbox.h>
#include <stdio.h>
#include <bwcc.h>
#include <window.h>
#include "bids.h"
#include "equip.h"
#include "bidsmain.h"
#include "bidsdial.h"
// I haven't optimised the include process. The SYM file gets rather
// large
// Also I haven't made all the header files "self-sufficient" though
// some contain examples of the technique of _CLASSDEF ing pointers

// Note the use of BWCC in this example
// It shows how to get a reliable load of BWCC
//
// Oh, check out the DEF file, for no good reason I have set a 20K stack
// (for all you people with the CodeBase documentation to battle with)
//

TMainWindow::TMainWindow(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  display = new TListBox(this, 500, 1,1,1,1);
  display->Attr.Style|=LBS_USETABSTOPS;
  display->Attr.Style&=~LBS_SORT; // I've remembered to take it out this time
  // Just for fun
  equipment = new EquipArray(50,0,50);
  BWCCGetVersion();  // This is the vital call to make BWCC work
					 // as the rest of BWCC happens by magic which
					 // the linker does not spot.
                     // This call forces an implicit load of BWCC.DLL
  AssignMenu("Commands");
}
TMainWindow::~TMainWindow()
	{
    	delete equipment; // Better sweep up before I go
    }
void TMainWindow::SetupWindow()
	{
		LONG dialogBaseUnits;
		int tabSize[2];
		TWindow::SetupWindow();
		dialogBaseUnits = GetDialogBaseUnits();
		tabSize[0] = 900
		 / LOWORD(dialogBaseUnits) ;
		SendMessage(display->HWindow,LB_SETTABSTOPS,1,(LONG)&tabSize);
		// The above is a bodged method of setting tab stops
		// The tab size required is dependent on the font selected
		// and is a pain to work out a good general method
        // maxCharWidth is usually too gappy for mix-case text
	}
void TMainWindow::WMSize(RTMessage msg)
	{
        RECT rect;
		TWindow::WMSize(msg);
		GetClientRect(HWindow,&rect);
		MoveWindow(display->HWindow,rect.left,rect.top,rect.right - rect.left,rect.bottom - rect.top, TRUE);
		// this makes the list box the same size as the parent window
        // a useful technique generally
	}
void TMainWindow::AddItem(RTMessage)
{
	// Responds to the Menu selection
	// Creates and calls the dialog, and if not ok, does nothing
	// if ok clears the list and re-adds all the items in the Sorted array
    // not that the sorting is done by the array, not the list box.
    char buffer[80];
	if (GetModule()->ExecDialog(new TAddDialog(this,equipment))==IDOK)
		{
			display->ClearList();
// Note that getItemsInContainer() gets the number of items,
// don't use arraySize as this only gives the limits
// For the unititiated C++ user
// the (*equipment) is a "dereference. As equipment is a pointer to EquipArray,
// you have to move along the pointer to the actual object to be able to
// use the [] operator. If you declared an EquipArray ea;
// you could then do ea[3] without the funny brackets.
// Not to be confused with "casting" which is turning something into soemthing
// else (without checks)
// Note also: none of these obscure "internal iterators" - makes it easy to
// follow doesn't it.
// Compare that with the sample code in OWL steps for the TPointArray
// It took months to grasp that. With the object based arrays, you end up either
// casting or deriving new access functions with casts to turn the objects into
// whatever you are storing. This way it is a lot more obvious.
// 
			for (int i = 0;i< equipment->getItemsInContainer();i++)
				{
					sprintf(buffer,"%s\t%s",(*equipment)[i].id,(*equipment)[i].description);
					display->AddString(buffer);
				}

}       }

