// *************************************************************** //
// Filename:    strmpnt.cpp                                        //
//                                                                 //
// Date:        Sep 15, 1993                                       //
//                                                                 //
// Description:                                                    //
//    Helper file for streaming examples.                          //
// *************************************************************** //
#include "strmpnt.h"

// =============================================================== //
// --------------------------------------------------------------- //
// T2DPoint                                                        //
// --------------------------------------------------------------- //
T2DPoint::T2DPoint(int i, int j) : 
  x(i), y(j)
{
}

void T2DPoint::Draw()
{
  cout << "Drawing 2D point at " << x << ", " << y << endl;
}

IMPLEMENT_CASTABLE(T2DPoint);
IMPLEMENT_STREAMABLE(T2DPoint);

void T2DPoint::Streamer::Write(opstream &os) const
{
  os << GetObject()->x << GetObject()->y;
}

void *T2DPoint::Streamer::Read(ipstream &in, uint32) const
{
  in >> GetObject()->x >> GetObject()->y;
  return (GetObject());
}

// =============================================================== //
// --------------------------------------------------------------- //
// T3DPoint                                                        //
// --------------------------------------------------------------- //
T3DPoint::T3DPoint(int i, int j, int k) : 
  T2DPoint(i, j), z(k)
{
}

void T3DPoint::Draw()
{
  cout << "Drawing 3D point at " << x << ", " << y << ", " << z << endl;
}

IMPLEMENT_CASTABLE1(T3DPoint, T2DPoint);
IMPLEMENT_STREAMABLE1(T3DPoint, T2DPoint);

void T3DPoint::Streamer::Write(opstream &os) const
{
  WriteBaseObject((T2DPoint *)GetObject(), os);
  os << GetObject()->z;
}

void *T3DPoint::Streamer::Read(ipstream &in, uint32) const
{
  ReadBaseObject((T2DPoint *)GetObject(), in);
  in >> GetObject()->z;
  return (GetObject());
}

// =============================================================== //
// --------------------------------------------------------------- //
// Color                                                           //
// --------------------------------------------------------------- //
TColor::TColor(int i, int j, int k) :
  r(i), g(j), b(k)
{
}

void TColor::DisplayColor()
{
  cout << "Color (" << r << ", " << g << ", " << b << ")" << endl;
}

// =============================================================== //
// --------------------------------------------------------------- //
// T2DPointColor                                                   //
// --------------------------------------------------------------- //
T2DPointColor::T2DPointColor(int aa, int bb, int cc, int dd, int ee) :
  T2DPoint(aa, bb), TColor(cc, dd, ee)
{
}

void T2DPointColor::Draw()
{
  DisplayColor();
  T2DPoint::Draw();
}

IMPLEMENT_CASTABLE2(T2DPointColor, T2DPoint, TColor);
IMPLEMENT_STREAMABLE2(T2DPointColor, T2DPoint, TColor);

void T2DPointColor::Streamer::Write(opstream &os) const
{
  WriteBaseObject((T2DPoint *)GetObject(), os);
  os << GetObject()->r << GetObject()->g << GetObject()->b;
}

void *T2DPointColor::Streamer::Read(ipstream &in, uint32) const
{
  ReadBaseObject((T2DPoint *)GetObject(), in);
  in >> GetObject()->r >> GetObject()->g >> GetObject()->b;
  return (GetObject());
}

