/*
    view.c

    viewport creation and control routines
*/

#include "defs.h"

extern  rect_t  screen, *cur_win, *cur_port;

vport_t    *inst_vport()
{
vport_t    *vp;

    if(( vp = CALLOC(1,vport_t)) == NULL)
        {
        error("Can't instantiate viewport");
        return(NULL);
        }
    else
        return(vp);
}

vport_t *new_vport(bitmap)
rect_t  *bitmap;
{
vport_t *vp, *inst_vport();
rect_t  result, *copy_rect();

    vp = inst_vport();
    vp->brder = WHITE;
    vp->bkgnd = BLACK;

    cur_win = &screen;

    if(sect_rect(bitmap, &screen, &result) == FALSE)
        {
        error("Viewport not within bitmap");
        exit(0);
        }

    cur_port = vp->bitmap = copy_rect(&result);

    set_map(&screen, &screen);
    set_color(WHITE);
    frame_rect(bitmap);

    vp->window = NULL;

    bitmap->top--;
    bitmap->left++;
    return(vp);
}

void    set_vport_seg(vp, seg)
vport_t *vp;
seg_t   *seg;
{
rect_t  *r, *copy_rect();

    vp->seg = seg;

    if(vp->window == NULL)
        vp->window = copy_rect(seg->bbox);
    else
        {
        r = seg->bbox;
        set_rect(vp->window, r->left, r->bottom, r->right, r->top);
        }
}


void    pan_vport(vp, dh, dv)
vport_t *vp;
int dh, dv;
{
    offset_rect(vp->window,-dh,-dv);
    if(vp->seg != NULL)
        {
        clear_vport(vp);
        draw_seg(vp->seg,vp);
        }
}

void    zoom_vport(vp, dh, dv)
vport_t *vp;
int dh, dv;
{
rect_t  *w;
/*  Do not let window get too small! */

    w = vp->window;

    if(w->left >= (w->right -2*dh))
        return;

    if(w->bottom >= (w->top - 2*dv))
        return;

    inset_rect(vp->window,dh,dv);
    if(vp->seg != NULL)
        {
        clear_vport(vp);
        draw_seg(vp->seg,vp);
        }
}
