/*
    draw.c

    Segment and Key Drawing routines
*/

#include    "defs.h"

/* Internal state vars */
int    wr_mode   = COPY;
int    fill_mode = NOFILL;
int    frame_mode = FRAME;
int    fg_clr    = WHITE;

/* Display Size */
rect_t    screen;

/* current window and view port */
rect_t  *cur_win    =   NULL;
rect_t  *cur_port   =   NULL;

void    list_draw(key, viewport)
key_t   *key;
vport_t  *viewport;
{
void    key_draw();

    if(viewport == NULL)
        {
        error("Segment viewport undefined in list_draw");
        return;
        }

    cur_port = viewport->bitmap;
    cur_win = viewport->window;

    re_map(cur_win, cur_port);
    set_map(cur_win, cur_port);

    while(key != NULL)
        {
        key_draw(key, viewport);
        key = key->next;
        }
}

void    key_draw(key, viewport)
key_t   *key;
vport_t  *viewport;
{
void    draw_line(), frame_rect(), frame_poly();

    if(ISATTR(key->type))
        {
        switch(key->type)
            {
            case    RESET   :   /* reset to initial state */
                wr_mode = COPY;
                fill_mode = NOFILL;
                frame_mode = FRAME;
                fg_clr = WHITE;
                set_color(fg_clr);
                break;

            case    COPY    :   wr_mode = COPY;      break;
            case    XOR     :   wr_mode = XOR;       break;

            case    FILL    :   fill_mode = FILL;    break;
            case    NOFILL  :   fill_mode = NOFILL;  break;

            case    FRAME   :   frame_mode = FRAME;   break;
            case    NOFRAME :   frame_mode = NOFRAME; break;

            default         :    fg_clr = key->type;
                set_color(fg_clr);
            }
        }
    else if(ISPRIM(key->type))
        {
        switch(key->type)
            {
            case    POINT    :
                {
                point_t *p; p = key->key.point;
                move_to(p->x, p->y);
                line_to(p->x, p->y);
                break;
                }
            case    LINE    :
                {
                line_t  *l; l = key->key.line;
                draw_line(l);
                break;
                }
            case    RECT    :
                {
                rect_t  *r; r = key->key.rect;

                if(fill_mode == FILL)
                    fill_rect(r);

                if(frame_mode == FRAME)
                    frame_rect(r);
                break;
                }
            case    TEXT    :
                {
                text_t  *t; t = key->key.text;
                draw_text(t->text, t->origin.x, t->origin.y, t->bbox);
                break;
                }
            case    REF    :
                {
                ref_t   *r;
                seg_t   *rd_seg();
                rect_t  *mf_bbox(), *copy_rect();
                r = key->key.ref;

                /* does the ref exist */
                if(r->instance == NULL)
                    {
                    r->instance = rd_seg(r->name);
                    instance(r->instance);
                    }

                /* did we read the metafile ? */
                if(r->instance != NULL)
                    {
                    vport_t vp;

                        vp.window = copy_rect(viewport->window);
                        vp.bitmap = viewport->bitmap;
                        vp.seg = r->instance;
                        vp.brder = viewport->brder;
                        vp.bkgnd = viewport->bkgnd;

                    offset_rect(vp.window, -r->origin.x, -r->origin.y);
                    draw_seg(r->instance, &vp);

                    free(vp.window);

                    cur_port = viewport->bitmap;
                    cur_win = viewport->window;

                    set_map(cur_win, cur_port);
                    }

                break;
                }
            case    POLY    :
                {
                poly_t  *p; p = key->key.poly;

                if(fill_mode == FILL)
                    fill_poly(p);
                if(frame_mode == FRAME)
                    frame_poly(p);
                break;
                }
            case    OVAL    :
                {
                oval_t  *o; o = key->key.oval;

                if(fill_mode == FILL)
                    fill_oval(o);
                if(frame_mode == FRAME)
                    frame_oval(o);
                break;
                }

            default :
                error("Unknown key type in keydraw");
            }
        }
}

/* rectangle intersection result */
rect_t  r;

void    draw_line(l)
line_t  *l;
{
cpoint_t    *cp;

    if(sect_rect( l->bbox, cur_win, &r))
        {
        cp = l->point;
        move_to(cp->point.x, cp->point.y);
        while(cp != NULL)
            {
            line_to(cp->point.x, cp->point.y);
            cp = cp->next;
            }
        }
}

void    frame_rect(rect)
rect_t  *rect;
{
    move_to(rect->left,  rect->bottom);
    line_to(rect->left,  rect->top);
    line_to(rect->right, rect->top);
    line_to(rect->right, rect->bottom);
    line_to(rect->left,  rect->bottom);
}

void    frame_poly(p)
poly_t  *p;
{
cpoint_t    *cp;

    if(sect_rect( p->bbox, cur_win, &r))
        {
        cp = p->point;
        move_to(cp->point.x, cp->point.y);
        while(cp != NULL)
            {
            line_to(cp->point.x, cp->point.y);
            cp = cp->next;
            }
        }
}
