/*
    diag.c

    diagnostic routines
*/

#include "defs.h"

char  mess[] = "DIAG : Attribute : ";

void    prt_point(p)
point_t    *p;
{
    printf("DIAG : Point %d, %d\n", p->x, p->y);
}

void    prt_rect(r)
rect_t  *r;
{
    printf("DIAG : Rect left/bottom %d, %d right/top %d, %d\n",
        r->left, r->bottom, r->right, r->top);
}

void    prt_line(l)
line_t  *l;
{
cpoint_t    *cp;

    printf("DIAG : Line, coords = ");

    cp = l->point;
    while(cp != NULL)
        {
        printf("%d,%d ",cp->point.x, cp->point.y);
        cp = cp->next;
        }
    printf("\n");
}

void    prt_poly(p)
poly_t  *p;
{
cpoint_t    *cp;

    printf("DIAG : Poly, coords = ");

    cp = p->point;
    while(cp != NULL)
        {
        printf("%d,%d ",cp->point.x, cp->point.y);
        cp = cp->next;
        }
    printf("\n");
}

void    prt_text(t)
text_t  *t;
{
    printf("DIAG : Text [%s], at %d, %d with %c, %c\n",
        t->text, t->origin.x, t->origin.y, t->just[0], t->just[1]);
}

void    prt_ref(r)
ref_t   *r;
{
    printf("DIAG : Reference [%s] at  %d, %d\n",
        r->name, r->origin.x, r->origin.y);
}

void    prt_oval(r)
rect_t  *r;
{
    printf("DIAG : Oval left/bottom %d, %d right/top %d, %d\n",
        r->left, r->bottom, r->right, r->top);
}


void    prt_seg(seg)
seg_t   *seg;
{
key_t   *k;

    if(seg->name != NULL)
        printf("DIAG : Segment [%s]\n",seg->name);
    else
        printf("DIAG : Segment [No Name !!!]\n");

    if(seg->bbox != NULL)
        {
        printf("\t\tExtent : ");
        prt_rect(seg->bbox);
        }

    k = seg->data;
    while(k != NULL)
        {
        switch(k->type)
            {
            /* primitives */
            case POINT  :   prt_point(k->key.point);        break;
            case LINE   :   prt_line(k->key.line);          break;
            case RECT   :   prt_rect(k->key.rect);          break;
            case TEXT   :   prt_text(k->key.text);          break;
            case REF    :   prt_ref(k->key.ref);            break;
            case POLY   :   prt_poly(k->key.poly);          break;
            case OVAL   :   prt_oval(k->key.oval);          break;

            /* attributes */
            case RESET  :   printf("%s RESET\n",mess);              break;
            case COPY   :   printf("%s Draw mode COPY\n",mess);     break;
            case XOR    :   printf("%s Draw mode XOR\n",mess);      break;
            case FILL   :   printf("%s FILL\n",mess);               break;
            case NOFILL :   printf("%s NOFILL\n",mess);             break;
            case FRAME  :   printf("%s FRAME\n",mess);              break;
            case NOFRAME :  printf("%s NOFRAME\n",mess);            break;
            case BLACK  :   printf("%s BLACK\n",mess);              break;
            case WHITE  :   printf("%s WHITE\n",mess);              break;
            case RED    :   printf("%s RED\n",mess);                break;
            case GREEN  :   printf("%s GREEN\n",mess);              break;
            case BLUE   :   printf("%s BLUE\n",mess);               break;
            case CYAN   :   printf("%s CYAN\n",mess);               break;
            case MAGENTA :  printf("%s MAGENTA\n",mess);            break;
            case YELLOW :   printf("%s YELLOW\n",mess);             break;
            }

        k = k->next;
        }
}
