/*
    defs1.h

    segment, key, primitive, and attribute declarations

    This file is for compilers which require an empty declaration of
    of a structure tag before a self-referencing pointer is allowed
    in the structure definition. Use this file if defs.h does not work.

*/

#define NULL 0

#define BOOLEAN int
#define TRUE 1
#define FALSE  0

#define BIG  (60*1024)
#define NBIG (-BIG)

char 	*malloc(), *calloc();
#define MALLOC(x)   ((x *) malloc(sizeof(x)))
#define CALLOC(n,x) ((x *) calloc(n,sizeof(x)))

/*
 * empty structure tag declarations so self-referencing pointers in
 * the structure declaration work correctly.
 */

struct	rect_primitive;
struct	cont_point;
struct 	line_primitive;
struct	poly_primitive;
struct	text_primitive;
struct	segment;
struct	reference;
struct	seg_key;
struct	viewport;
struct	diskkey;


struct  point_primitive
    {
    int x, y;
    };

typedef struct  point_primitive point_t;
point_t *inst_point();

struct  rect_primitive
    {
    int left, bottom, right, top;
    };

typedef struct  rect_primitive  rect_t;
rect_t  *inst_rect();

struct  cont_point
    {
    point_t point;
    struct  cont_point  *next;
    };

typedef struct  cont_point  cpoint_t;

struct  line_primitive
    {
    int     num_points;
    rect_t  *bbox;
    struct  cont_point  *point;
    };

typedef struct  line_primitive  line_t;
line_t  *inst_line();
line_t  *close_line();

struct  poly_primitive
    {
    int     num_points;
    rect_t  *bbox;
    struct  cont_point  *point;
    };

typedef struct  poly_primitive  poly_t;
poly_t  *inst_poly();
poly_t  *close_poly();

#define oval_t  rect_t
#define inst_oval   inst_rect

/*
    text justification definitions
*/

#define TOP     't'
#define CENTER  'c'
#define BOTTOM  'b'
#define LEFT    'l'
#define MIDDLE  'm'
#define RIGHT   'r'
#define TXTSZE  32

struct  text_primitive
    {
    point_t origin;
    rect_t  *bbox;
    char    just[2];    /* justification */
    char    text[TXTSZE];
    };

typedef struct  text_primitive  text_t;
text_t  *inst_text();

struct  reference
    {
    point_t origin;
    struct  segment *instance;
    char    name[TXTSZE];
    };

typedef struct  reference   ref_t;
ref_t   *inst_ref();

/*
    key primitive types
*/

#define POINT   1
#define LINE    2
#define RECT    3
#define POLY    4
#define OVAL    5
#define TEXT    6
#define REF     7
#define ISPRIM(x)   ((x) < 8 ? TRUE : FALSE)

struct  seg_key
    {
    int type;
    union
        {
        char    *ptr;
        point_t *point;
        line_t  *line;
        rect_t  *rect;
        poly_t  *poly;
        oval_t  *oval;
        text_t  *text;
        ref_t   *ref;
        }   key;
    struct  seg_key *next;
    };

typedef struct  seg_key key_t;
key_t   *inst_key();

/*
    dynamic segment construction macros
*/

#define add_attr(a)     append(a,NULL)
#define add_point(p)    append(POINT,p)
#define add_line(l)     append(LINE,l)
#define add_rect(r)     append(RECT,r)
#define add_poly(p)     append(POLY,p)
#define add_oval(o)     append(OVAL,o)
#define add_text(t)     append(TEXT,t)
#define add_ref(r)      append(REF,r)

/*
    attribute definitions
*/

#define RESET   99

#define COPY    10
#define XOR     11

#define FILL    12
#define NOFILL  13
#define FRAME   14
#define NOFRAME 15

#define BLACK   20
#define RED     21
#define GREEN   22
#define BLUE    23
#define CYAN    24
#define MAGENTA 25
#define YELLOW  26
#define WHITE   27

#define ISATTR(x)   ((x) >= 10 ? TRUE : FALSE)

/*
    segment descriptor
*/

struct  segment
    {
    int num_inst, visible, locked;
    char    *name;
    rect_t  *bbox;
    key_t   *data,
            *eol;
    struct  segment *next;
    };

typedef struct  segment seg_t;
seg_t   *cl_seg();  /* close segment */

/*
    viewport descriptor
*/

struct  viewport
    {
    rect_t  *bitmap,
            *window;
    int     brder, bkgnd;   /* colors */
    seg_t   *seg;
    };
typedef struct  viewport    vport_t;

/*
    metafile key
*/

struct    diskkey
    {
    int type;
    int size;
    };
typedef    struct    diskkey    disk_key_t;

