/*
    cons.c

    Complex primitive construction routines
*/

#include    "defs.h"

static  line_t      *l    =    NULL;
static  poly_t      *p    =    NULL;
static  cpoint_t    *cur  =    NULL;
static  cpoint_t    *first =   NULL;
static  rect_t  *bbox = NULL;
rect_t  *new_bbox();

void    con_point(x, y)
int     x, y;
{
cpoint_t    *cp;

    if( (cp = CALLOC(1, cpoint_t)) == NULL)
        error("Can't instantiate Continue Point");
    else
        {
        if(first == NULL)
            first = cur = cp;
        else
            {
            cur->next = cp;
            cur = cur->next;
            }

        cur->point.x = x;
        cur->point.y = y;
        set_bbox(bbox,x,y);
        }
}


void    begin_line()
{
    if((l != NULL) | (p != NULL))
        {
        error("Can't reopen line, close current primitive");
        return;
        }

    if( (l = CALLOC(1, line_t)) == NULL)
        error("Can't instantiate line");

    bbox = new_bbox();
}

line_t    *end_line()
{
line_t    *temp;
cpoint_t  *cp;
int    i = 0;

    if(first == NULL)
        error("Line contains zero points");

    if(l == NULL)
        {
        error("Can't close unopened line");
        return(NULL);
        }
    else
        {
        l->point = first;
        cp = first;
        while(cp != NULL)
            {
            i++;
            cp = cp->next;
            }

        l->num_points = i;
        l->bbox = bbox;
        bbox = NULL;

        temp = l;

        /* reset for the next line */
        first = cur = l = NULL;
        return(temp);
        }
}

void    begin_poly()
{
    if((l != NULL) | (p != NULL))
        {
        error("Can't reopen polygon, close current primitive");
        return;
        }

    if( (p = CALLOC(1, poly_t)) == NULL)
        error("Can't instantiate polygon");

    bbox = new_bbox();
}

poly_t    *end_poly()
{
poly_t    *temp;
cpoint_t  *cp;
int    i = 0;

    if(first == NULL)
        error("Poly contains zero points");
    if(p == NULL)
        {
        error("Can't close unopened poly");
        return(NULL);
        }
    else
        {
        /* make sure that last point == first point ! */
        if((first->point.x != cur->point.x) || 
           (first->point.y != cur->point.y))
           con_point(first->point.x, first->point.y);

        p->point = first;
        cp = first;
        while(cp != NULL)
            {
            i++;
            cp = cp->next;
            }

        p->num_points = i;
        p->bbox = bbox;
        bbox = NULL;

        temp = p;
        first = cur = p = NULL;
        return(temp);
        }
}
