/*
    main.c

    test program for segmentation system
*/

#include        "defs.h"

void    main()
{
/* function returns to be moved to globals.h */
seg_t   *cl_seg(), *rd_seg();
vport_t *new_vport();

/* pointers to items */
seg_t   *door, *window, *house, *city;

/* pointers to viewports */
vport_t *vp1, *vp2, *vp3;

int     i, j, k;

    initialize();    /* graphics display */

/* create-window segment */

        cr_seg("window");
        add_attr(RESET);
        rect(10,10,60,80);
        rect(10,00,60,90);
        window = cl_seg();

/* create-door segment */

        cr_seg("door");
        add_attr(RESET);
        rect(10,0,100,270);
        door = cl_seg();

/* create-house segment */

        cr_seg("house");

        add_attr(RESET);
        rect(100,100,600,500);
        begin_line();
        con_point(50,480);
        con_point(350,600);
        con_point(650,480);
        add_line(end_line());

        ref("window",150,300,NULL);
        ref("window",250,300,NULL);
        ref("window",350,300,NULL);

        text("House", 0, 0, LEFT , BOTTOM);

        ref("door",450,100,NULL);

    house = cl_seg();

/* create-city segment */

        cr_seg("city");

        add_attr(RESET);
        ref("house",0,0,NULL);
        ref("house",1000,00,NULL);
        ref("house",0,700,NULL);
        ref("house",1100,800,NULL);

        text("City Block", 0, -100, LEFT , BOTTOM);


        city = cl_seg();

/* can write these segments to metafiles with */

    wr_seg(window);
    wr_seg(door);
    wr_seg(house);
    wr_seg(city);

/* purge segments from memory */

    del_seg(window);
    del_seg(door);
    del_seg(house);
    del_seg(city);

/* later read metafiles back into segments */

    window  = rd_seg("window");
    door    = rd_seg("door");
    house   = rd_seg("house");
    city    = rd_seg("city");

/* draw segments in three different viewports */


    /* set up viewports */
    vp1 = new_vport(inst_rect(1, 1, 300, 500));
    vp2 = new_vport(inst_rect(1, 500, 600, 799));
    vp3 = new_vport(inst_rect(300, 1, 600, 500));

    /* assign segments to viewports */
    set_vport_seg(vp1, window);
    set_vport_seg(vp2, house);
    set_vport_seg(vp3, city);

    /* draw segments in viewports */
    draw_seg(window, vp1);
    draw_seg(house, vp2);
    draw_seg(city, vp3);

    for(j=0;j<100;j++)
        {
        pan_vport(vp2,5,5);
        zoom_vport(vp3,-10,-10);
        }

    sleep(10);
    terminate();    /* graphics display */
}
