;library of text mode cursor routines
;independently authored by George Vanous

PARMA   equ     6               ;necessary for far procedures
PARMB   equ     PARMA + 2
PARMC   equ     PARMB + 2
PARMD   equ     PARMC + 2

TCUR    equ     -1              ;text cursor identification
MCUR    equ     -2              ;mouse cursor identification
ACUR    equ     -3              ;memory cursor identification
GRAFIX  equ     10              ;identification for 640x480x16 graphics mode

KEYBEEP MACRO
        push ax
        push dx
        mov  ah,02
        mov  dl,07
        int  21h
        pop  dx
        pop  ax
ENDM

extrn  TXTOFF_A:word            ;offset of active text page
extrn  TXTOFF_V:word            ;offset of visual text page

public CUROFF                   ;offset of cursor on active text page
public CUROFF1                  ;offset of cursor on text page 1
public CUROFF2                  ;offset of cursor on text page 2
public CUROFF3                  ;offset of cursor on text page 3
public CUROFF4                  ;offset of cursor on text page 4
public CUROFF5                  ;offset of cursor on text page 5
public CUROFF6                  ;offset of cursor on text page 6
public CUROFF7                  ;offset of cursor on text page 7
public CUROFF8                  ;offset of cursor on text page 8
public CURSHP                   ;cursor shape on active text page
public CUROFFo			;offsets of CUROFF?
public CURSHP1                  ;cursor shape on text page 1
public CURSHP2                  ;cursor shape on text page 2
public CURSHP3                  ;cursor shape on text page 3
public CURSHP4                  ;cursor shape on text page 4
public CURSHP5                  ;cursor shape on text page 5
public CURSHP6                  ;cursor shape on text page 6
public CURSHP7                  ;cursor shape on text page 7
public CURSHP8                  ;cursor shape on text page 8
public CURSHPo			;offsets of CURSHP?

public __cur_get                ;01
public __cur_getx               ;02
public __cur_gety               ;03
public __cur_off                ;04
public __cur_on                 ;05
public __cur_set                ;06
public __cur_setx               ;07
public __cur_sety               ;08
public __cur_shapeget           ;09
public __cur_shapeset           ;10

;*****************************************************************************
_TEXT   segment byte public 'CODE'

        assume  cs:_TEXT,ds:_DATA

;-----------------------------------------------------------------------------
__cur_get proc  far             ;MODIFIES AX BX CX
; void _cur_get(byte *x, byte *y);

        push bp                 ;
        mov  bp,sp              ;
        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  bx,CUROFF         ;
         mov  ax,[bx]           ;AX = offset of cursor
         sub  ax,TXTOFF_A       ;AX = offset of cursor on active text page
         mov  cl,050h           ;CL = 80 (byte-length of one text row)
         div  cl                ;AH = cursor abscissa   AL = cursor ordinate
         mov  bx,[bp+PARMC]     ;BX = offset of cursor ordinate pointer
         or   bx,bx             ;offset = NULL (the first paramater is "*xy")?
         jz   skip01a           ;jump if so
         mov  ds,[bp+PARMD]     ;DS:BX = segment:offset of cursor ordinate ptr
         mov  [bx],al           ;store cursor ordinate
         lds  bx,[bp+PARMA]     ;DS:BX = segment:offset of cursor abscissa ptr
         mov  [bx],ah           ;store cursor abscissa
         jmp  short out01       ;
skip01a: lds  bx,[bp+PARMA]     ;DS:BX = seg:off of cur. abscissa/ordinate ptr
         xchg al,ah             ;AH = cursor ordinate   AL = cursor abscissa
         mov  [bx],ax           ;store cursor abscissa then cursor ordinate
out01:  pop  ds                 ;
        pop  bp                 ;
        ret                     ;

__cur_get endp

;-----------------------------------------------------------------------------
__cur_getx proc far             ;MODIFIES AX BX
; byte _cur_getx(void);

        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  bx,CUROFF         ;
         mov  ax,[bx]           ;AX = offset of cursor
         sub  ax,TXTOFF_A       ;AX = offset of cursor on active text page
         mov  bl,050h           ;BL = 80 (byte-length of one text row)
         div  bl                ;AX = AX / BL (cursor address / 160)
         mov  al,ah             ;AL = cursor abscissa
         xor  ah,ah             ;AX = cursor abscissa
        pop  ds                 ;
        ret                     ;return cursor abscissa

__cur_getx endp

;-----------------------------------------------------------------------------
__cur_gety proc far             ;MODIFIES AX BX
; byte _cur_gety(void);

        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  bx,CUROFF         ;
         mov  ax,[bx]           ;AX = offset of cursor
         sub  ax,TXTOFF_A       ;AX = offset of cursor on active text page
         mov  bl,050h           ;BL = 80 (byte-length of one text row)
         div  bl                ;AX = AX / BL (cursor address / 160)
         xor  ah,ah             ;AH = cursor ordinate
        pop  ds                 ;
        ret                     ;return cursor ordinate

__cur_gety endp

;-----------------------------------------------------------------------------
__cur_off proc  far             ;MODIFIES AX DX
; void _cur_off(void);

         mov  al,0Ah            ;address Cursor Start Register
         mov  dx,03D4h          ;DX = 03D4h, address of CRT Controller reg.
         out  dx,al             ;set Cursor Start Register active
         in   ax,dx             ;AH = value of Cursor Start Register
         or   ah,00100000b      ;set Cursor On/Off (COO) to 1 (off)
         out  dx,ax             ;turn off the cursor
        ret                     ;

__cur_off endp

;-----------------------------------------------------------------------------
__cur_on proc   far             ;MODIFIES AX DX
; void _cur_on(void);

         mov  al,0Ah            ;address Cursor Start Register
         mov  dx,03D4h          ;DX = 03D4h, address of CRT Controller reg.
         out  dx,al             ;set Cursor Start Register active
         in   ax,dx             ;AH = value of Cursor Start Register
         and  ah,11011111b      ;set Cursor On/Off (COO) to 0 (on)
         out  dx,ax             ;turn on the cursor
        ret                     ;

__cur_on endp

;-----------------------------------------------------------------------------
__cur_set proc  far             ;MODIFIES AX BX CX DX
; byte _cur_set(byte x, byte y);

        push bp                 ;
        mov  bp,sp              ;
        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  al,[bp+PARMA]     ;AL = cursor abscissa
         xor  ah,ah             ;AX = cursor abscissa
         mov  cl,[bp+PARMB]     ;CL = cursor ordinate
         mov  ch,ah             ;CX = cursor ordinate
         push ax                ;needed for "__cursetx" and "__cursety"
jump06a: shl  cx,1              ;ordinate * 2
         shl  cx,1              ;ordinate * 4
         shl  cx,1              ;ordinate * 8
         shl  cx,1              ;ordinate * 16
         mov  bx,cx             ;BX = ordinate * 16
         shl  cx,1              ;ordinate * 32
         shl  cx,1              ;ordinate * 64
         add  cx,bx             ;ordinate*64 + ordinate*16 = ordinate*80
         add  cx,ax             ;DI = ordinate*80 + abscissa
         mov  ax,TXTOFF_A       ;AX = offset of active text page
         add  cx,ax             ;position in active text page
         mov  bx,CUROFF         ;
         mov  [bx],cx           ;store offset of cursor on active text page
         cmp  ax,TXTOFF_V       ;active page offset = video page offset?
         jne  out06             ;jump if not so
         mov  al,0Eh            ;address Cursor Location High register
         mov  ah,ch             ;AH = new cursor position high
         mov  dx,03D4h          ;DX = 03D4h, address of CRT Controller reg.
         out  dx,ax             ;set Cursor Location High
         inc  al                ;AL = 0Fh, address Cursor Location Low reg.
         mov  ah,cl             ;AH = new cursor position low
         out  dx,ax             ;set Cursor Location Low
out06:  pop  ax                 ;AX = cursor abscissa or cursor ordinate
        pop  ds                 ;
        pop  bp                 ;
        ret                     ;return cursor abscissa or cursor ordinate

__cur_set endp

;-----------------------------------------------------------------------------
__cur_setx proc far             ;MODIFIES AX BX DX
; byte _cur_setx(byte x);

        push bp                 ;
        mov  bp,sp              ;
        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  bx,CUROFF         ;
         mov  ax,[bx]           ;AX = offset of cursor
         sub  ax,TXTOFF_A       ;AX = offset of cursor on active text page
         mov  bl,050h           ;BL = 80 (byte-length of one text row)
         div  bl                ;AX = AX / BL (cursor address / 160)
         xor  ah,ah             ;AX = cursor ordinate
         push ax                ;save ordinate for return value
         mov  cx,ax             ;CX = cursor ordinate
         mov  al,[bp+PARMA]     ;AX = desired cursor abscissa
         jmp  short jump06a     ;

__cur_setx endp

;-----------------------------------------------------------------------------
__cur_sety proc far             ;MODIFIES AX BX DX
; byte _cur_sety(byte y);

        push bp                 ;
        mov  bp,sp              ;
        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  bx,CUROFF         ;
         mov  ax,[bx]           ;AX = offset of cursor
         sub  ax,TXTOFF_A       ;AX = offset of cursor on active text page
         mov  bl,050h           ;BL = 80 (byte-length of one text row)
         div  bl                ;AX = AX / BL (cursor address / 160)
         mov  al,ah             ;AL = cursor abscissa
         xor  ah,ah             ;AX = cursor abscissa
         push ax                ;save abscissa for return value
         mov  cl,[bp+PARMA]     ;CL = cursor ordinate
         mov  ch,ah             ;CX = cursor ordinate
         jmp  short jump06a     ;

__cur_sety endp

;-----------------------------------------------------------------------------
__cur_shapeget proc far         ;MODIFIES AX BX CX DX
; void _cur_shapeget(byte *start, byte *end);

        push bp                 ;
        mov  bp,sp              ;
        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  bx,CURSHP         ;
         mov  dx,[bx]           ;DH = ending scanline   DL = starting scanline
         mov  bx,[bp+PARMC]     ;BX = offSET of ending scan line pointer
         or   bx,bx             ;offset of ending scan line pointer = NULL?
         jz   skip09a           ;jump if so
         mov  ds,[bp+PARMD]     ;DS:BX = seg:off of ending scan line pointer
         mov  [bx],dh           ;store ending scan line of cursor
         lds  bx,[bp+PARMA]     ;DS:BX = seg:off of starting scan line pointer
         mov  [bx],dl           ;store starting scan line of cursor
         jmp  short out09       ;
skip09a: lds  bx,[bp+PARMA]     ;DS:BX = seg:off of start/end scan line ptr
         mov  [bx],dh           ;store starting scan line of cursor
         mov  [bx+01h],dl       ;store ending scan line of cursor
out09:  pop  ds                 ;
        pop  bp                 ;
        ret                     ;

__cur_shapeget endp

;-----------------------------------------------------------------------------
__cur_shapeset proc far         ;MODIFIES AX BX CX DX
; void _cur_shapeset(byte start, byte end);

        push bp                 ;
        mov  bp,sp              ;
        push ds                 ;
         mov  ax,seg _DATA      ;
         mov  ds,ax             ;DS = segment of our data
         mov  cl,[bp+PARMA]     ;CL = new starting scan line of cursor
         cmp  cl,0FFh           ;modify the starting scan line?
         je   skip10a           ;jump if not so
         mov  [bx],cl           ;store new starting scan line of cursor
skip10a: mov  ch,[bp+PARMB]     ;CH = new ending scan line of cursor
         cmp  cx,0FFFFh         ;do not modify starting and ending scan line?
         je   out10a            ;jump if so
         mov  [bx+01h],ch       ;store new ending scan line of cursor
skip10b: mov  ax,TXTOFF_A       ;AX = offset of active text page
         cmp  ax,TXTOFF_V       ;active page offset = video page offset?
         jne  out10             ;jump if not so

         mov  al,0Ah            ;address Cursor Start Register
         mov  dx,03D4h          ;DX = 03D4h, address of CRT Controller reg.
         cmp  cl,0FFh           ;modify the starting scan line?
         je   skip10c           ;jump if not so
         out  dx,al             ;set Cursor Start Register active
         in   ax,dx             ;AH = value of Cursor Start Register
         and  ah,11100000b      ;mask out current starting scan line of cursor
         or   ah,cl             ;input new starting scan line of cursor
         out  dx,ax             ;set Cursor Start Register
skip10c: inc  al                ;AL = 0Bh, address Cursor End Register
         cmp  ch,0FFh           ;modify the ending scan line?
         je   out10             ;jump if not so
         out  dx,al             ;set Cursor End Register active
         in   ax,dx             ;AH = value of Cursor End Register
         and  ah,11100000b      ;mask out current ending scan line of cursor
         or   ah,ch             ;input new ending scan line of cursor
         out  dx,ax             ;set Cursor End Register
out10:  pop  ds                 ;
        pop  bp                 ;
        ret                     ;
out10a: KEYBEEP                 ;beep to signify error
         jmp  short out10       ;

__cur_shapeset endp

;-----------------------------------------------------------------------------
_TEXT   ends                    ;end of code segment

;*****************************************************************************
_DATA   segment byte public 'DATA'

;-----------------------------------------------------------------------------

;all offsets are relative to B000:8000
CUROFF	dw   CUROFF1		;offset of cursor on active text page
CUROFF1 dw   0000h		;offset of cursor on text page 1
CUROFF2 dw   0FA0h		;offset of cursor on text page 2
CUROFF3 dw   1F40h		;offset of cursor on text page 3
CUROFF4 dw   2EE0h		;offset of cursor on text page 4
CUROFF5 dw   3E80h		;offset of cursor on text page 5
CUROFF6 dw   4E20h		;offset of cursor on text page 6
CUROFF7 dw   5DC0h		;offset of cursor on text page 7
CUROFF8 dw   6D60h		;offset of cursor on text page 8
CUROFFo dw   CUROFF1		;offsets of CUROFF?
	dw   CUROFF2		;
	dw   CUROFF3		;
	dw   CUROFF4		;
	dw   CUROFF5		;
	dw   CUROFF6		;
	dw   CUROFF7		;
	dw   CUROFF8		;

CURSHP  dw   CURSHP1            ;cursor shape on active text page
CURSHP1 dw   0D0Eh              ;cursor shape on text page 1
  ; [cursor starting scan line] [cursor ending scan line] (back-words storage)
CURSHP2 dw   0D0Eh              ;cursor shape on text page 2
CURSHP3 dw   0D0Eh              ;cursor shape on text page 3
CURSHP4 dw   0D0Eh              ;cursor shape on text page 4
CURSHP5 dw   0D0Eh              ;cursor shape on text page 5
CURSHP6 dw   0D0Eh              ;cursor shape on text page 6
CURSHP7 dw   0D0Eh              ;cursor shape on text page 7
CURSHP8 dw   0D0Eh              ;cursor shape on text page 8
CURSHPo dw   CURSHP1		;offsets of CURSHP?
	dw   CURSHP2		;
	dw   CURSHP3		;
	dw   CURSHP4		;
	dw   CURSHP5		;
	dw   CURSHP6		;
	dw   CURSHP7		;
	dw   CURSHP8		;

;-----------------------------------------------------------------------------
_DATA   ends

;*****************************************************************************
        end                     ;end of assembly
