/* TITLE:     Blank Screen Saver
   PROGRAM:   blankss.cpp
   DATE:      08/29/94
*/

#include <stdlib.h>
#include <windows.h>
#include "ss.h"

#include "blankss.h"
#include "blankss.rh"


// GLOBALS (compatible w/ Msft's screen saver names)
//    (1) Shared with lib module
HINSTANCE hMainInstance;
HWND hMainWindow;
BOOL bPassword;
//    (2) Private to this module
char szAppName[40] = "Screen Saver.Blank";  
// Change 'Blank' to the name of your app.  Also, see .DEF file comment


/* METHOD:   WinMain
   PURPOSE:  Provides the WinMain routine for a Windows
   PARAMS:   Std Win params
   RETURN:   int
*/

#pragma argsused

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow )
{
   MSG          msg;
   WNDCLASS     wndclass;
   char         cSwitch;
   DLGPROC      lpfnConfigDlgProc;
   HWND         hwnd = NULL;

   hMainInstance = hInstance;

   if ( hPrevInstance ) 
      return 1;

   // Get private settings
   GetProfile();   

   // If the command line has an -s, /s, or s, launch screen saver
   cSwitch = lpszCmdParam[0];
   if ( cSwitch == '/' || cSwitch == '-' ) 
      cSwitch = lpszCmdParam[1];

   if ( cSwitch == 's' || cSwitch == 'S' )
   {
      wndclass.style          = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc    = ScreenSaverProc;
      wndclass.cbClsExtra     = 0;
      wndclass.cbWndExtra     = 0;
      wndclass.hInstance      = hInstance;
      wndclass.hIcon          = LoadIcon( hInstance, "ID_APP");
      wndclass.hCursor        = NULL;
      wndclass.hbrBackground  = GetStockObject( BLACK_BRUSH );
      wndclass.lpszMenuName   = NULL;
      wndclass.lpszClassName  = szAppName;
     
      if ( !RegisterClass( &wndclass ) )
         return 1;

      hwnd = CreateWindow( szAppName,
                           szAppName,
                           WS_POPUP | WS_VISIBLE,
                           0,
                           0,
                           GetSystemMetrics( SM_CXSCREEN ),
                           GetSystemMetrics( SM_CYSCREEN ),
                           NULL,
                           NULL,
                           hInstance,
                           NULL
                         );

      if ( !hwnd )
         return 1;

      hMainWindow = hwnd;

      // Std win msg loop
      while ( GetMessage( &msg, NULL, 0, 0 ) ) {
         TranslateMessage( &msg );
         DispatchMessage( &msg );
      }
      return msg.wParam;
   }

   else {
      // If no cmd line switch, display config dialog box.
      lpfnConfigDlgProc 
         = MakeProcInstance( (DLGPROC) ScreenSaverConfigureDialog, hInstance );
      if ( RegisterDialogClasses( hInstance ) ) {
         DialogBox( hInstance, "DLG_SCRNSAVECONFIGURE", NULL, lpfnConfigDlgProc );
      }
      FreeProcInstance( lpfnConfigDlgProc );
      return 0;
   } 
}


/* METHOD:   ScreenSaverProc
   PURPOSE:  Win proc
   PARAMS:   std Win params
   CALLER:   Win
   RETURN:   LONG
*/

#pragma argsused

LONG CALLBACK _export 
ScreenSaverProc( HWND hwnd, UINT uiMsg, UINT wParam, LONG lParam )
{
   switch ( uiMsg )
   {

      /*
      Draw something cute here to convert this into an entertaining screen saver
      */
   }
   // *** SS LIB CALL ***
   return DefScreenSaverProc( hwnd, uiMsg, wParam, lParam );
}


/* METHOD:   RegisterDialogClasses
   PURPOSE:  Called by the screen saver applet during
             initialzation, to reg. custom win classes
   PARAMS:   Instance handle
   RETURN:   BOOL
*/

#pragma argsused

BOOL CALLBACK RegisterDialogClasses( HANDLE hInstance )
{
   /*
   Register any custom classes here
   */
   return TRUE;
}


/* METHOD:   ScreenSaverConfigureDialog
   PURPOSE:  Dlg proc for config dlg
   PARAMS:   std Win params
   CALLER:   WinMain
   RETURN:   BOOL
*/

#pragma argsused

BOOL CALLBACK _export 
ScreenSaverConfigureDialog( HWND hwndDlg, UINT uiMsg, UINT wParam, LONG lParam )
{
   switch ( uiMsg )
   {
      case WM_INITDIALOG:
         // To be used for children of this dlg
         hMainWindow = hwndDlg;
         
         // Read current profile 
         GetProfile();
         
         // Set control based on profile information 
         CheckDlgButton( hwndDlg, IDC_PWCHECKBOX, bPassword );
         EnableWindow( GetDlgItem( hwndDlg, IDC_SETPWBUTTON ), bPassword );
         
         return TRUE;

      case WM_COMMAND:
         switch ( wParam )
         {
            case IDC_PWCHECKBOX:
               // toggle
               bPassword ^= 1;
               CheckDlgButton( hwndDlg, wParam, bPassword );
               EnableWindow( GetDlgItem( hwndDlg, IDC_SETPWBUTTON ), bPassword );
               return TRUE;

            case IDC_SETPWBUTTON:
               // *** SS LIB CALL ***
               // ss lib will write new pw out to control file
               DlgSetPassword();
               return TRUE;

            case IDOK:
               // Write Profile
               SetProfile();
               EndDialog( hwndDlg, TRUE );
               return TRUE;

            case IDCANCEL:
               EndDialog( hwndDlg, FALSE );
               return TRUE;
         }
         break;
   }
   return FALSE;
}


/* METHOD:   GetProfile
   PURPOSE:  Read strs from control.ini
   PARAMS:   void
   RETURN:   void
*/

void CALLBACK
GetProfile( void )
{
   bPassword = GetPrivateProfileInt( szAppName, ISPASSWORD, FALSE, CONTROLFILE );

   // add others, as desired
   // ...
}


/* METHOD:   SetProfile
   PURPOSE:  Write str(s) to control.ini
   PARAMS:   void
   RETURN:   void
*/

void CALLBACK
SetProfile( void )
{
   char szTemp[10];

   itoa( bPassword, szTemp, 10 );
   WritePrivateProfileString( szAppName, ISPASSWORD, szTemp, CONTROLFILE );

   // add others, as desired
   // ...
} 
