/* FIXDOVL.C - Fixes Borland C++ 3.0 DPMI16BI.OVL
 * to work properly under DESQVIEW

 * COMPILE with:  bcc -mt -lt -P-c fixdovl (makes fixdovl.com)

 * DPMI16BI.OVL is the DOS EXTENDER portion of the code.
 * It is loaded under basically one of two modes, with VCPI (V86 mode)
 * or without VCPI (in real mode).  This module is not used
 * when running under Windows.

 * The error in DPMI16BI was a serious VCPI infraction, which caused
 * all hardware interrupts to be "flaky."  Basically, the specification
 * for VCPI says that if a prior client before the new client has
 * remapped hardware irq's (0-0x0F), or they have been remapped by the
 * server, then the interrupts must not be remapped.  The bug (or design)
 * of DPMI16BI was remapping the interrupts anyway.  The fix is too
 * eliminate the remapping conflict.  
 
 * If you don't have a 'C' compiler, use the binary I've provided
 *
 * If you have any questions, or problems, feel free to contact me.
 *
 * Philip B. Gardner 70053,3157
 */

#include <stdio.h>
#include <string.h>
#include <process.h>

char help[] = "\nfixdovl (dpmi16bi.ovl's pathname) [-u]\n"
			  "   -u is optional and reverses the patch\n"
			  "   (i.e. fixdovl c:\\borlandc\\bin\\dpmi16bi.ovl)" ;
#define datalen 	96

unsigned char patch[3][datalen] = {
	{
	0xE8, 0x52, 0x14, 0xC3, 0x50, 0x53, 0x51, 0xE8,
	0xE7, 0x01, 0x80, 0xFC, 0x00, 0x75, 0x4D, 0x83,
	0x0E, 0x01, 0x04, 0x01, 0x83, 0x0E, 0x01, 0x04,
	0x10, 0xC6, 0x06, 0x00, 0x04, 0x03, 0x2E, 0xC6,
	0x06, 0x91, 0x10, 0x07, 0x2E, 0xC6, 0x06, 0x92,
	0x10, 0x07, 0x2E, 0xC6, 0x06, 0x93, 0x10, 0x05,
	0x2E, 0xC7, 0x06, 0x94, 0x10, 0x00, 0x00, 0x2E,
	0xC7, 0x06, 0x96, 0x10, 0x00, 0x00, 0xB8, 0x0A,
	0xDE, 0xCD, 0x67, 0x83, 0xFB, 0x08, 0x75, 0x07,
	0x83, 0xF9, 0x70, 0x75, 0x02, 0xEB, 0x0D, 0x83,
	0x0E, 0x01, 0x04, 0x20, 0x88, 0x1E, 0x65, 0x04,
	0x88, 0x0E, 0x66, 0x04, 0x59, 0x5B, 0x58, 0xC3
	},
	{
	0xE8, 0x52, 0x14, 0xC3, 0x60, 0xEB, 0x00, 0xE8,
	0xE7, 0x01, 0x80, 0xFC, 0x00, 0x75, 0x4F, 0x83,
	0x0E, 0x01, 0x04, 0x01, 0x83, 0x0E, 0x01, 0x04,
	0x10, 0xC6, 0x06, 0x00, 0x04, 0x03, 0x2E, 0xC6,
	0x06, 0x91, 0x10, 0x07, 0x2E, 0xC6, 0x06, 0x92,
	0x10, 0x07, 0x2E, 0xC6, 0x06, 0x93, 0x10, 0x05,
	0x2E, 0xC7, 0x06, 0x94, 0x10, 0x00, 0x00, 0x2E,
	0xC7, 0x06, 0x96, 0x10, 0x00, 0x00, 0xB8, 0x0A,
	0xDE, 0xCD, 0x67, 0x83, 0xFB, 0x08, 0x75, 0x07,
	0x83, 0xF9, 0x70, 0x75, 0x02, 0xEB, 0x0F, 0x83,
	0x0E, 0x01, 0x04, 0x20, 0x88, 0xCF, 0x89, 0x1E,
	0x65, 0x04, 0x89, 0x1E, 0x67, 0x04, 0x61, 0xC3
	}
	} ;

#define start 	(0x45B8L)
#define broke 	(patch[0])
#define fixit 	(patch[1])
#define buffer 	(patch[2])

void main(int argc, char *argv[])
{
	FILE *fp ;
	int state ;
	char *search = broke ;
	char *update = fixit ;

	for(state = 4 ; state>=0 ; state--)
	
	switch(state)	{

		case 4:
			if (argc < 2)	{
				puts(help) ;
				goto out ;
				}
			break ;
		case 3:
			if ((fp = fopen(argv[1],"rb+")) == NULL)	{
				printf("Unable able to open %s\n",argv[1]) ;
				goto out ;
				}
			if (argc > 2 && argv[2][0] == '-')	{
				switch(argv[2][1])	{
					case 'u':
					case 'U':
						update = broke ;
						search = fixit ;
					}
				}
			break ;
		case 2:
			if (fseek(fp,start,SEEK_SET)
				|| fread(buffer,1,datalen,fp) != datalen
				|| memcmp(buffer,search,datalen))	{
				printf("Wrong version of %s\n",argv[1]) ;
				goto out ;
				}
			break ;
		case 1:
			if (fseek(fp,-datalen,SEEK_CUR)
				|| fwrite(update,1,datalen,fp) != datalen)	{
				printf("Error patching %s\n",argv[1]) ;
				goto out ;
				}
			break ;
		case 0:
			printf("Successfully %spatched %s\n",
					(search==fixit)?"un":"\0",argv[1]) ;
		}

out:
	if (fp != NULL)	fclose(fp) ;
	exit(state) ;
	}

/* DPMI16BI.OVL ------------------------------------------------------------- */

/*	---------- BUG ----------			; offset 045BC in DPMI16BI.EXE

	PUSH    AX							; save some regs
	PUSH    BX
	PUSH    CX
	CALL    47A9						; detect if VCPI
	CMP     AH,00
	JNZ     4614						; no return
	OR      WORD PTR [0401],+01			; set some flags
	OR      WORD PTR [0401],+10
	MOV     BYTE PTR [0400],03
	CS:
	MOV     BYTE PTR [1091],07
	CS:
	MOV     BYTE PTR [1092],07
	CS:
	MOV     BYTE PTR [1093],05
	CS:
	MOV     WORD PTR [1094],0000
	CS:
	MOV     WORD PTR [1096],0000
	MOV     AX,DE0A						; VCPI Get 8259 mapping
	INT     67
	CMP     BX,+08						; BX = IRQ 0 - 7 Base
	JNZ     4607
	CMP     CX,+70						; CX = IRQ 8 - 0Fh Base
	JNZ     4607
	JMP     4614						; not mapped, return
	OR      WORD PTR [0401],+20 		; set flag (is it ever used?)
	MOV     [0465],BL					; save IRQ0 base					
	MOV     [0466],CL					; save IRQ8 base
	POP     CX
	POP     BX
	POP     AX
	RET
*/

/*	---------- FIX ---------- 

	PUSHA								; save all regs (to gain code space)
	JMP		$+2							; filler
	CALL    47A9						; detect if VCPI
	CMP     AH,00
	JNZ     4614+2						; no return (adjust jump)
	OR      WORD PTR [0401],+01			; set some flags
	OR      WORD PTR [0401],+10
	MOV     BYTE PTR [0400],03
	CS:
	MOV     BYTE PTR [1091],07
	CS:
	MOV     BYTE PTR [1092],07
	CS:
	MOV     BYTE PTR [1093],05
	CS:
	MOV     WORD PTR [1094],0000
	CS:
	MOV     WORD PTR [1096],0000
	MOV     AX,DE0A						; VCPI Get 8259 mapping
	INT     67
	CMP     BX,+08						; BX = IRQ 0 - 7 Base
	JNZ     4607
	CMP     CX,+70						; CX = IRQ 8 - 0Fh Base
	JNZ     4607
	JMP     4614+2						; not mapped, return (adjust jump)
	OR      WORD PTR [0401],+20 		; set flag (is it ever used?)
	MOV		BH,CL						; put both bases in BX
	MOV     [0465],BX					; save IRQ0-8 base for VCPI
	MOV     [0467],BX	; FIX HERE		; now equals IRQ0-8 default mapping
	POPA								; restore regs (1 byte instr.)
	RET
*/
/* -------------------------------------------------------------------------- */
