//============================================================================
// Class: 	BCD
// Version: 1.0
// Files: 	bcd.cpp bcd.hpp util.hpp x_range.hpp xception.hpp
// ------------------------------------------------------------------------
// Description: A C++ class that implements Binary Coded Decimal (BCD).
// 				 Representing floating point values in a BCD representation
// 				 alleviates the inaccuracies inherent in a binary 
//					 representation of real numbers.
//============================================================================
// DISCLAIMER
// 								BCD C++ Class
// 						Copyright 1994 Troy Hakala
// 
// This class is shareware.  If you use this class, a $20 (or whatever you 
// think is fair) contribution would be greatly appreciated.  You are free to 
// redistribute this class in any format as long as the this disclaimer
// remains intact and the source code is not modified in any way.
//============================================================================
//
//Please send contributions to the following address:
//
//					Troy Hakala
//					46702 Sandalwood Square
//					Sterling VA 20164
//
//Please send any/all suggestions/comments/criticisms to one of the 
//following email addresses:
//	
//					Internet: troy@digex.net
//					CompuServe: 70254,3072
//
//============================================================================

#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <iomanip.h>
#include <ctype.h>

#include "x_range.hpp"
#include "util.hpp"


#ifndef _BCD_hpp
#define _BCD_hpp


class BCD
{
	friend ostream& operator<<(ostream&, const BCD&);

	char _val[20];
	unsigned int _dec;
	enum {NEGATIVE, POSITIVE} _sign;

	static char int2bcd(unsigned int);
	static unsigned int bcd2int(char);
	static unsigned int operand(const BCD& b, int pos);

	unsigned int mantissa_space() const {return((sizeof(_val)*2) - _dec);}
	unsigned int fractional_space() const {return(_dec);}
	unsigned int integer_value_length() const;
	unsigned int fractional_value_length() const;

public:
	BCD(int, unsigned int = 0);
	BCD(const char*, unsigned int = 0);
	BCD() : _dec(0) { memset(_val, 0, sizeof(_val)); }
	BCD(const BCD& obj) : _dec(0) { *this = obj; }
	~BCD() {}
	BCD& operator=(const BCD&);

	// arithmetic operations
	BCD& operator+=(const BCD&);
	BCD& operator-=(const BCD&);
	BCD operator+(const BCD&) const;
	BCD operator-(const BCD&) const;

	// equality operators
	int operator<(const BCD&) const;
	int operator>(const BCD& b)  const { return !(*this < b) && (*this != b); }
	int operator<=(const BCD& b) const { return (*this < b) || (*this == b); }
	int operator>=(const BCD& b) const { return (*this > b) || (*this == b); }
	int operator==(const BCD& b) const { return !(*this != b); }
	int operator!=(const BCD&) const ;
};

#endif
