//============================================================================
// Class: 	BCD
// Version: 1.0
// Files: 	bcd.cpp bcd.hpp util.hpp x_range.hpp xception.hpp
// ------------------------------------------------------------------------
// Description: A C++ class that implements Binary Coded Decimal (BCD).
// 				 Representing floating point values in a BCD representation
// 				 alleviates the inaccuracies inherent in a binary 
//					 representation of real numbers.
//============================================================================
// DISCLAIMER
// 								BCD C++ Class
// 						Copyright 1994 Troy Hakala
// 
// This class is shareware.  If you use this class, a $20 (or whatever you 
// think is fair) contribution would be greatly appreciated.  You are free to 
// redistribute this class in any format as long as the this disclaimer
// remains intact and the source code is not modified in any way.
//============================================================================
//
//Please send contributions to the following address:
//
//					Troy Hakala
//					46702 Sandalwood Square
//					Sterling VA 20164
//
//Please send any/all suggestions/comments/criticisms to one of the 
//following email addresses:
//	
//					Internet: troy@digex.net
//					CompuServe: 70254,3072
//
//============================================================================

#ifndef _XCEPTION_HPP
#define _XCEPTION_HPP

#include <iostream.h>

class Exception
{
	friend ostream& operator<<(ostream& os, Exception& x);

	int _code;
	unsigned int _source_line;
	const char* _source_file;

protected:
	const char* _exception_name;

public:
	Exception() : _code(0), _source_line(0), _source_file(0), _exception_name("Exception") {}
	Exception(int n) : _code(n), _source_line(0), _source_file(0), _exception_name("Exception") {}
	Exception(int n, const char* fn, unsigned int l)
		: _code(n), _source_line(l), _source_file(fn), _exception_name("Exception") {}
	Exception(const Exception& e) { *this = e; }
	~Exception() {}

	Exception& operator=(const Exception& e)
	{
		_code			  = e._code;
		_source_line  = e._source_line;
		_source_file  = e._source_file;
		return *this;
	}

	const char* name() { return _exception_name; }
};

#endif
