//============================================================================
// Class: 	BCD
// Version: 1.0
// Files: 	bcd.cpp bcd.hpp util.hpp x_range.hpp xception.hpp
// ------------------------------------------------------------------------
// Description: A C++ class that implements Binary Coded Decimal (BCD).
// 				 Representing floating point values in a BCD representation
// 				 alleviates the inaccuracies inherent in a binary 
//					 representation of real numbers.
//============================================================================
// DISCLAIMER
// 								BCD C++ Class
// 						Copyright 1994 Troy Hakala
// 
// This class is shareware.  If you use this class, a $20 (or whatever you 
// think is fair) contribution would be greatly appreciated.  You are free to 
// redistribute this class in any format as long as the this disclaimer
// remains intact and the source code is not modified in any way.
//============================================================================
//
//Please send contributions to the following address:
//
//					Troy Hakala
//					46702 Sandalwood Square
//					Sterling VA 20164
//
//Please send any/all suggestions/comments/criticisms to one of the 
//following email addresses:
//	
//					Internet: troy@digex.net
//					CompuServe: 70254,3072
//
//============================================================================

#include "xception.hpp"

class RangeException : public Exception
{
public:
	enum
	{
		UNDERFLOW = 1,
		OVERFLOW
	};

	RangeException() {_exception_name="RangeException";}
	RangeException(int n, const char* fn = 0, unsigned int l = 0) : Exception(n, fn, l) {_exception_name="RangeException";}
	RangeException(const RangeException& re) : Exception(re) {}
	~RangeException() {}
};
