/*
 *
 * Standard Tags used by all programs.
 *
 * (C) 1990 Vision Software
 *
 * $Id: stdhdr.h 1.2001 91/04/25 15:06:41 pcalvin release $
 *
 * Comments:
 *
 * This file includes tags and macros that are abstract enough to be available
 * for all applications
 *
 * Bugs:
 *
 * None documented
 *
 */
#if (!defined(__STDHDR__))
#define __STDHDR__

/*
 * Nearly everyone needs STDIO
 */
#include <stdio.h>

/*
 * Pointless redefinitions of C syntax
 */
#define EXTERN extern
#define STATIC static
#define REGISTER register
#define INLINE inline
#define VIRTUAL virtual
#define FRIEND friend
#define FAR far
#define VOID void
#define FLOAT float
#define DOUBLE double
#define INT int
#define UINT unsigned int
#define LONG long
#define ULONG unsigned long
#define CHAR char
#define UCHAR unsigned char
#define CONST const
#define VOLATILE volatile
#define UNION union

/*
 * Character based types
 */
typedef INT CCH;					/* Counter of charactes */
typedef CHAR *PCH;					/* Pointer to characters */
typedef UCHAR *PUCH;				/* Pointer to unsigned characters */

/*
 * String related types
 */
#define cchSzTempMax 255
typedef CHAR SZTEMP[cchSzTempMax];	/* Temporary string manipulation */
typedef CHAR *SZ;					/* Null terminated strings. */
typedef INT CSZ;					/* Count of strings.. */
typedef INT DSZ;					/* Difference between two strings.. */

/*
 * Generic types..
 */
typedef INT CL;						/* Line count */

/*
 * Generic Boolean type.
 */
typedef INT BOOL;
STATIC CONST BOOL fFalse = 0;
STATIC CONST BOOL fTrue = 1;

/*
 * Nil values for each type
 */
#define Nil 0
STATIC CONST VOID *pvNil = 0;
STATIC CONST FILE *stmNil = 0;
STATIC CONST SZ szNil = 0;
STATIC CONST CCH cchNil = 0;
STATIC CONST CHAR chNil = 0;
STATIC CONST PCH pchNil = 0;
STATIC CONST PUCH puchNil = 0;

/*
 * Some Useful ASCII constants
 */
STATIC CONST CHAR chSpace = ' ';
STATIC CONST CHAR chReturn = '\n';
STATIC CONST CHAR chTab = '\t';

/*
 * Run-time error detection systems
 */
EXTERN VOID IOError(SZ sz,...);
EXTERN VOID AssertFailed(CL cl,SZ sz);
EXTERN VOID AssertFailedSz(CL cl,SZ sz,SZ szMessage);
/*
 * Debugging is ON
 */
#define __DEBUG__

#if (defined(__DEBUG__))
#define Assert(f)					((f) ? (VOID) 0 : AssertFailed(__LINE__,__FILE__))
#define AssertSz(f,sz)			((f) ? (VOID) 0 : AssertFailedSz(__LINE__,__FILE__,sz))
#define Verify(f)					Assert(f)
#define VerifySz(f,sz)			AssertSz(f,sz)
#define MemoryAssert(f) 		AssertSz((f),"Out of memory")
#define PointerAssert(f)		AssertSz((f),"Nil pointer found")
#define NotReached()				AssertSz(fFalse,"Unreachable code")
#else
#define Assert(f)
#define Verify(f)				(f)
#define AssertSz(f,sz)
#define VerifySz(f,sz)			(f)
#define MemoryAssert(f)
#define PointerAssert(f)
#define NotReached()
#endif

#endif /* !defined(__STDHDR__) */
