/*
 *
 *	Baseball statistic manager
 *
 * (C) 1991 Vision Software
 *
 * $Id: stats.h 1.1 91/03/22 14:50:03 pcalvin beta $
 *
 */
#if (!defined(__STATS__))
#define __STATS__

/*
 *	Everything you wanted to know about Hitters..
 */
struct HITTERS : public DBASE
	{
	CHAR rgchName[15];
	CHAR rgchID[4];
	CHAR rgchTeam[3];
	CHAR rgchAverage[4];
	CHAR rgchGames[3];
	CHAR rgchAtBat[3];
	CHAR rgchRuns[3];
	CHAR rgchHits[3];
	CHAR rgchTotal[3];
	CHAR rgchDoubles[3];
	CHAR rgchTriples[3];
	CHAR rgchHomeRuns[3];
	CHAR rgchRBI[3];
	CHAR rgchWalks[3];
	CHAR rgchSO[3];
	CHAR rgchStolen[2];
	CHAR rgchCaught[2];
	CHAR rgchErrors[2];
	};

/*
 *	Just as much information about Batters..
 */
struct PITCHERS : public DBASE
	{
	CHAR rgchName[15];
	CHAR rgchID[4];
	CHAR rgchTeam[3];
	CHAR rgchWins[2];
	CHAR rgchLoses[2];
	CHAR rgchERA[5];
	CHAR rgchGames[3];
	CHAR rgchComplete[3];
	CHAR rgchShutouts[3];
	CHAR rgchSaves[3];
	CHAR rgchInnings[5];
	CHAR rgchHits[3];
	CHAR rgchRuns[3];
	CHAR rgchEarned[3];
	CHAR rgchHomeRuns[3];
	CHAR rgchWalks[3];
	CHAR rgchSO[3];
	};
	
/*
 *	Functions to Edit/Report for Batters..
 */
EXTERN VOID CreateHitters();
EXTERN VOID BattingChamps();
EXTERN VOID HomeRunChamps();
EXTERN VOID StolenBaseChamps();

/*
 *	Functions to Edit/Report for Pitchers
 */
EXTERN VOID CreatePitchers();
EXTERN VOID ERAChamps();
EXTERN VOID WinChamps();
EXTERN VOID SaveChamps();
EXTERN VOID StrikeoutChamps();

/*
 *	Filter functions for REPORTS
 */
EXTERN BOOL FValidBatter(DBASE *pdb);
EXTERN BOOL FValidPitcher(DBASE *pdb);

/*
 *	Standard reports..
 */
EXTERN VOID HittersReport(DATABASE &rdtb,HITTERS &rhtrs,BOOL (*pfnFValid)(DBASE *pdb),BOOL fForward = fFalse);
EXTERN VOID PitchersReport(DATABASE &rdtb,PITCHERS &rpchrs,BOOL (*pfnFValid)(DBASE *pdb),BOOL fForward = fFalse);

#endif 	/* !defined(__STATS__) */
