/*
 *
 * Class Implementation for Popup menu system
 *
 * (C) 1990 Vision Software
 *
 * $Id: scroll.c 1.2001 91/04/25 15:07:59 pcalvin release $
 *
 * Comments:
 *
 * Scroll boxes.  Simple implementation due to POPUP handling most of the
 * difficult operation for us.
 *
 * Bugs:
 *
 * None documented
 *
 */
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

#include <stdhdr.h>
#include <adl.h>
#include <menu.h>

/*
 * Public constructors, used by the general public for
 * General scroll boxes..
 */
SCROLL::SCROLL(ROW row,COL col,CENT cent,PENT pent,CENT centView,SZ sz) : POPUP(row,col,cent,pent,sz)
	{
	centTop = 0;
	centViewMax = centView;
	}

/*
 * Displays a row, Scrolls the box if necessary.
 */
VOID SCROLL::Display(CENT cent,PENT pent,WINDOW &rwnd,BOOL fSelected)
	{
	PointerAssert(pent);
	PointerAssert(pent[cent].sz);

	CO coBack = fSelected ? coGreen : coCyan;

	if (cent - centTop < centViewMax)
		{
		SZ sz = SzFromCentPent(cent,pent);
		CCH cch = pent[cent].cchHotKey+1;

		rwnd.SayHot(cent-centTop,0,sz,cch,coBlack,coBack);
		}
	}

BOOL SCROLL::FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd)
	{
	BOOL fContinue = fTrue;
	/*
	 * Defaults to no exit, must prove otherwise.
	 */
	switch (cd)
		{
	case cdCursorUp:
		if (rcent > 0)
			{
			Display(rcent,pent,rwnd,fFalse);
			if (rcent > centTop)
				{
				rcent -= 1;
				}
			else
				{
				rwnd.ScrollDrow(-1);
				centTop -= 1;
				rcent -= 1;
				}
			}
		break;
	case cdCursorDown:
		if (rcent+1 < centMax)
			{
			Display(rcent,pent,rwnd,fFalse);
			if (rcent+1 < centTop + centViewMax)
				{
				rcent += 1;
				}
			else if (centTop + 1 < centMax)
				{
				rwnd.ScrollDrow(1);
				centTop += 1;
				rcent += 1;
				}
			}
		break;
	default:
		fContinue = POPUP::FHandleCd(rcent,cd,pent,rwnd);
		break;
		}

	return (fContinue);
	}

VOID SCROLL::KeepInView(CENT cent)
	{
	if (cent < centTop)
		centTop = cent;
	else if (cent >= (centTop+centViewMax))
		centTop = (cent - centViewMax+1);
	}

ROW SCROLL::CrowFromCentPent(CENT centMac,PENT pent)
	{
	Assert(pent != pentNil);
	Assert(pent->sz != szNil);
	Assert(centViewMax <= centMac);

	return (centViewMax);
	}

