/*
 *
 *	Report processing/creation
 *
 * (C) 1990 Vision Software
 *
 * $Id: report.h 1.2001 91/04/25 15:06:47 pcalvin release $
 *
 * Comments:
 *
 *	This class will create/manage reports from any database.
 *
 * Bugs:
 *
 *	None documented
 *
 */
#if (!defined(__REPORT__))
#define __REPORT__

#if (!defined(__DATABASE__))
#include <dbase.h>
#endif

/*
 *	Title Alignment.
 */
enum AL 
	{
	alLeft,alCentre,alRight
	};
	
/*
 * Maintaining list of report entries..
 */
struct EN
	{
	struct EN *penNext;
	struct EN *penPrev;
	COL col;
	SZ sz;
	CCH cch;
	SZ szTitle;
	};

typedef UINT CEN;
STATIC CONST CEN cenNil = Nil;
typedef struct EN *PEN;
STATIC CONST PEN penNil = (PEN)Nil;

/*
 *	Report Titles
 */
struct TL
	{
	struct TL *ptlNext;
	SZ sz;
	AL al;
	};

typedef UINT CTL;
STATIC CONST CTL ctlNil = Nil;
typedef struct TL* PTL;
STATIC CONST PTL ptlNil = (PTL)Nil;
	
/*
 *	Report Generation
 */
class REPORT
	{
public:
	REPORT(DATABASE &rdtb);
	~REPORT();
	VOID Title(SZ sz,AL al = alCentre);
	VOID Entry(COL col,SZ sz,CCH cch,SZ szTitle = szNil);
	VOID SetFilterTo(BOOL (*pfnFUse)(DBASE *pdb));
	VOID Generate(BOOL fForward = fTrue,BOOL fPrinter = fFalse);
private:
	VOID CreateTitle(SZ szText,SZ szBar);
	VOID CreateOutput(SZ sz);
	VOID OutputFix(SZ sz,CCH cch);
	DATABASE &rdtb;
	BOOL (*pfnFUsePdb)(DBASE *pdb);
	PEN penFirst;
	PEN penCurrent;
	PTL ptlFirst;
	PTL ptlCurrent;
	CTL ctlCurrent;
	CCH cchReportWidthMac;
	SZTEMP szTitleText;
	SZTEMP szTitleBar;
	};

	
#endif	/* !defined(__REPORT__) */
