/*
 *
 * Database indexing system
 *
 * (C) 1990 Vision Software
 *
 * $Id: index.h 1.2001 91/04/25 15:06:44 pcalvin release $
 *
 * Comments:
 *
 * In general, this class will not be used by the General Public.  It
 * provides string based searching of records in a database file.
 * In addition, it will allow us to traverse a database in a logical
 * order after records have been deleted/added etc..
 *
 * Bugs:
 *
 * None documented
 *
 */
#if (!defined(__INDEX__))
#define __INDEX__

#if (!defined(__ACCESS__))
#include <access.h>
#endif

/*
 *
 *	Index length.  The index key is set by DATABASE as
 *	we are created
 *
 */
STATIC CONST CCH cchIndexKeyMax = 255;

/*
 *
 * Index file format.  Basically the index is a disk-based binary tree.
 *	Access takes care of the "Head" of the tree
 *
 *	I use two classes here in order to ease computation of the index
 *	record sizes
 *
 *	record size = sizeof(ITREE) + cchIndex;
 *
 */
struct ITREE : public INF
	{
	friend class INDEX;
private:
	REC rec;							// Record number to access in DATABASE
	REC recLeft;					// Next record to the LEFT in the INDEX
	REC recRight;					// Next record to the RIGHT in the INDEX
	REC recParent;					// Parent of this Branch in INDEX
	REC recNext;					//	Next record of identical key
	REC recPrevious;				// Previous record of identical key
	};
	
struct IDX : public ITREE
	{
	friend class INDEX;
private:
	CHAR rgchKey[cchIndexKeyMax];
	};

/*
 *
 * Database indexes.  File access is controlled by ACCESS.
 *
 */
class INDEX : private ACCESS
	{
public:
	INDEX(SZ sz,CCH cchKeyMac);
	REC RecFromSz(SZ sz,CCH cch,BOOL fMatchIfClose);
	REC RecCreateSz(SZ sz,CCH cch,REC recCreate);
	REC RecFirst();
	REC RecLast();
	REC RecNext();
	REC RecPrevious();
	REC RecDelete();
	ACCESS::FMark;
	ACCESS::FGotoMark;
private:
	BOOL FLastInChain();
	BOOL FFirstInChain();
	REC RecCreateDuplicate(SZ sz,CCH cch,REC recCreated);
	REC RecFromSzCchRecRec(SZ sz,CCH cch,REC recCreate,REC recParent);
	REC RecDeleteRight(REC recOriginal,REC recParent,REC recRight,REC recLeft);
	REC RecDeleteLeft(REC recOriginal,REC recParent,REC recRight,REC recLeft);
	REC RecDeleteLeftLinear(REC recOriginal,REC recParent,REC recRight);
	REC RecDeleteRightLinear(REC recOriginal,REC recParent,REC recLeft);
	IDX idx;
	};

#endif	/* !defined(__ACCESS__) */
