/*
 *
 * Field editing system.
 *
 * (C) 1990 Vision Software
 *
 * $Id: field.h 1.2002 91/05/04 17:19:57 pcalvin beta $
 *
 * Comments:
 *
 * Right now, this system is just used by EDIT to handle I/O for each field
 * in the edit.  In the future, it may be used by others (such is interactive
 * dialog boxes)
 *
 * Bugs:
 *
 * None documented
 *
 */
#if (!defined(__FIELD__))
#define __FIELD__

#if (!defined(__ADL__))
#include <adl.h>
#endif

#if (!defined(__MENU__))
#include <menu.h>
#endif

/*
 * Validation functions.
 */
typedef BOOL (*PFN)(SZ sz,VOID *pv = Nil);
static const PFN pfnNil = 0;

/*
 * Titles/Headers that may be put anywhere on the screen
 */
struct IF
	{
public:
	IF(WINDOW &rwnd,ROW rowStart,COL colStart,SZ sz);
	VOID SayMessage();
	ROW RowEdit();
	COL ColRight();
	COL ColLeft();

	struct IF *pifPrev;
	struct IF *pifNext;

protected:
	WINDOW &rwnd;
private:
	SZ szMessage;			  	/* Message  */
	ROW row;					/* Offset within the window.. */
	COL col;
	};
typedef IF *PIF;
STATIC CONST PIF pifNil = 0;

/*
 * Edit Ordered field.  An extension of the the information field, this
 * one may be dynamic..
 */
struct ED : public IF
	{
public:
	ED(WINDOW &rwnd,ROW row,COL col,SZ szMsg,SZ sz,SZ szPicture,SZ szHelp,SZ szDefault);
	ED(WINDOW &rwnd,ROW row,COL col,SZ szMsg,SZ sz,CHAR chPicture,CCH cch,SZ szHelp,SZ szDefault);
	ED(WINDOW &rwnd,ROW row,COL col,SZ szMsg,SZ sz,CCH cch,SZ szHelp,CENT cent,PENT pent,CENT centDflt);
	BOOL FInsertCd(CD cd);
	BOOL FDelete();
	BOOL FModified();
	BOOL FValidate();
	VOID CursorLeft();
	VOID CursorRight();
	VOID SayEdit(BOOL fCurrent);
	VOID Adjust(PFN pfn,VOID *pv,BOOL fCareIfFieldChanges);
	VOID UpdateHelp(HELP &rhelp);
	VOID Clear();
	VOID ShowDelimiters(CHAR chLeft,CHAR chRight);
	VOID SetUnchanged();
	VOID SetCursor();
	COL ColLeft();
	COL ColRight();
	COL ColEdit();
private:
	CHAR ChPicture();
	BOOL FValidChCh(CHAR &rch,CHAR chPicture);
	BOOL FValidateRange();
	BOOL FValidateFunction();
	BOOL FInRange();
	BOOL FIsConstantPic();
	BOOL FAdvanceCursor();
	BOOL FStripLeader();
	BOOL FInsertLeader();
	COL DcolOffset();
	SZ sz;							/* Place edit here.. */
	SZ szHelp;						/* Help message */
	SZ szPicture;					/* Simple validation string */
	SZ szDefault;					/* Default value when the field is cleared */
	CHAR chPicture;				/* Single charcter picture for input */
	PFN pfnValid;					/* Validation Function */
	VOID *pvValid;					/* Pointer passed to validation function */
	CENT centValid;				/* Number of entries in validation array */
	PENT pentValid;				/* Validation array.. */
	COL dcol;						/* Offset for edit cursor */
	CCH cchMax;						/* Max Length of field */
	CCH cchMac;						/* Current length of field */
	CCH cchCurrent;				/* Current offset for editing */
	BOOL fChanges;					/* Has this field been modified */
	BOOL fCareAboutChanges;		/* Do we CARE if this field changes?? */
	BOOL fNumeric;
	};

typedef ED *PED;
STATIC CONST PED pedNil = 0;

#endif	/* !defined(__FIELD__) */
