/*
 *
 * Class Implementation for Popup menu system
 *
 * (C) 1990 Vision Software
 *
 * $Id: dialog.c 1.2001 91/04/25 15:08:00 pcalvin release $
 *
 * Comments:
 *
 * This class provides simple dialog box management.  Nothing spectacular,
 * We basically provide services to ask a question and get certain responses
 *
 * Bugs:
 *
 * None documented
 *
 */
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

#include <stdhdr.h>
#include <adl.h>
#include <menu.h>

/*
 * Derivative of POPUP().  We provide our own display and and keyboard
 * routines..
 */
DIALOG::DIALOG(SZ sz,CENT centMax,PENT pent) : POPUP(rowNil,colNil,centMax,pent)
	{
	szLine = sz;
	}

DIALOG::~DIALOG()
	{
	if (pcolTabs != Nil)
		delete pcolTabs;
	}

/*
 *	We replace the original Redraw() so that we may present the message
 */
VOID DIALOG::Redraw()
	{
	POPUP::Redraw();

	wnd.SayAt(1,2,szLine);
	}

/*
 * Answers with the total width of all of the selection entries..
 */
CCH DIALOG::CchFromCentPent(CENT centMax,PENT pent)
	{
	CCH cch = 4;

	pcolTabs = new COL[centMax];
	MemoryAssert(pcolTabs);
	PointerAssert(pent);
	/*
	 * Figure total width of Buttons when they are displayed as needed..
	 */
	for (CENT cent = centNil; cent < centMax; cent++)
		{
		pcolTabs[cent] = cch;
		cch += strlen(pent[cent].sz) + 2;
		}

	return (cch);
	}

/*
 * Displays each entry..
 */
VOID DIALOG::Display(CENT cent,PENT pent,WINDOW &rwnd,BOOL fSelected)
	{
	PointerAssert(pcolTabs);
	PointerAssert(pent);
	PointerAssert(pent[cent].sz);

	COL col = dcolButtons + pcolTabs[cent];
	CO coBack = fSelected ? coGreen : coCyan;
	SZ sz = SzFromCentPent(cent,pent);
	CCH cch = pent[cent].cchHotKey+1;

	rwnd.SayHot(3,col,sz,cch,coBlack,coBack);
	}

/*
 * For dialog boxes, TAB is used to move between selections.  Because
 * of this, we overide the Up/Down keys.
 */
BOOL DIALOG::FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd)
	{
	BOOL fContinue = fTrue;

	switch (cd)
		{
	case cdTab:
		Display(rcent,pent,rwnd,fFalse);
		rcent += 1;
		if (rcent >= centMax)
			rcent = centNil;
		break;
	case cdCursorUp:
	case cdCursorDown:
		break;
	default:
		fContinue = POPUP::FHandleCd(rcent,cd,pent,rwnd);
		break;
		}

	return (fContinue);
	}

/*
 * Provide POPUP() with the dimensions of the windows..
 */
COL DIALOG::ColLeftFromCentPent(CENT cent,PENT pent)
	{
	PointerAssert(szLine);

	CCH cchMessage = strlen(szLine);
	CCH cchButtons = CchFromCentPent(cent,pent);

	if (cchMessage > cchButtons)
		{
		cchWidth = cchMessage;
		dcolButtons = (cchMessage - cchButtons) >> 1;
		}
	else
		{
		cchWidth = cchButtons;
		dcolButtons = 0;
		}

	return ((colGlobalWindowRight - cchWidth) >> 1);
	}

/*
 *	Answers with the row to display the dialog on..
 */
ROW DIALOG::RowTopFromCentPent(CENT cent,PENT pent)
	{
	return (7);
	}

COL DIALOG::CcolFromCentPent(CENT centMac,PENT pent)
	{
	return (cchWidth + 2);
	}

ROW DIALOG::CrowFromCentPent(CENT centMac,PENT pent)
	{
	return (5);
	}
