/*
 *
 * Critical RUN-Time error handling systems.
 *
 * (C) 1990 Vision Software
 *
 * $Id: error.c 1.2001 91/04/25 15:07:54 pcalvin release $
 *
 * Comments:
 *
 * Handles Fatal Errors and Run-Time asserts throughout the library.
 *
 * Bugs:
 *
 * What if we assert here??
 *
 */
#include <iostream.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include <stdhdr.h>

#include <adl.h>
#include <menu.h>

/*
 * Fatal Errors..
 */
STATIC ENT pentFatal[] = { {"Exit Program",0,0,0} };

STATIC VOID
FatalError(SZ sz)
	{
	DIALOG dial(sz,1,pentFatal);

	dial.CentGet();

	exit(12);
	}

/*
 * Simple File/Line assert
 */
EXTERN VOID
AssertFailed(CL cl,SZ szFile)
	{
	SZTEMP sz;

	sprintf(sz,"Assertion Failed: %s, line %d",szFile,cl);

	FatalError(sz);
	}

/*
 * Provides more information to the user
 */
EXTERN VOID
AssertFailedSz(CL cl,SZ szFile,SZ szMessage)
	{
	SZTEMP sz;

	sprintf(sz,"Assertion Failed: %s: %s, line %d",szMessage,szFile,cl);

	FatalError(sz);
	}

/*
 * IO errors..
 */
EXTERN VOID
IOError(SZ szFormat,...)
	{
	SZTEMP sz;
	va_list args;

	va_start(args,szFormat);
	vsprintf(sz,szFormat,args);
	va_end(args);

	FatalError(sz);
	}
