

/* this include file gives you INTERRUPT DRIVEN KEYBOARD INPUT !

   perfect for keyboard driven realtime simulator games !

   starkeyboard - saves the old int 9 (keyboard interrupt) handler
		  addresss, and installs a new int 9 handler. the
		  new handler updates an array that tracks the state
		  (pressed or not pressed) of the keys, and then calls the
		  old int 9 handler.

   keypressed(i) - looks up the current state of the key with scancode i.
		   returns 1 if key with scancode i is pressed, else
		   returns 0.

   stopkeyboard - restores the old int 9 handler.

   */




#ifdef __cplusplus
extern "C" {
#endif




void startkeyboard(void);
/* clears keys array, saves old int 9 handler address, installs new int 9
   handler.

   call once before accessing keys array */




void stopkeyboard(void);
/* restores old int 9 handler. call when done accessing keys array */






int keypressed(int i);
/* returns 1 if key pressed, else returns 0. i is the key's scancode */




#ifdef __cplusplus
}
#endif

