BIDIRECTIONAL ASSOCIATIVE MEMORY SYSTEMS IN C++
by Adam Blum


////////////////////////////////////////////////////////////
// BAM.HPP  Provide vector, matrix, vector pair, matrix, BAM
matrix, and 
// BAM system classes and methods to implement BAM system concept.
// Extended note:
// This is an implementation of the concept of Bidirectional
// Associative Memories as developed by Bart Kosko and others. 
// It includes the extended concept introduced by Patrick Simpson
// of the "BAM System". Where reasonable Simpson's notation has
been
// been maintained. The presentation benefits greatly from C++ and
OOP, in that
// (I believe) it is both easier to understand than a "pseudocode"
version, 
// yet more precise (in that it works!)
// Developed with Zortech C++ Version 2.0 -- Copyright (c) Adam
Blum, 1989,90

#include<stdlib.h>
#include<io.h>
#include<stdio.h>
#include<string.h>
#include<limits.h>
#include<ctype.h>
#include<stream.hpp>
#include "debug.h" // debugging devices
// where are Zortech's min,max?
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))

// will be changed to much higher than these values
const ROWS=16; // number of rows (length of first pattern)
const COLS=8;  // number of columns (length of second pattern)
const MAXMATS=10; // maximum number of matrices in BAM system
const MAXVEC=16; // default size of vectors

class matrix;
class bam_matrix;
class vec {
     friend class matrix;
     friend class bam_matrix;
     friend class bam_system;
          int n;
          int *v;
     public:
          // see BAM.CPP for implementations of these
          vec(int size=MAXVEC,int val=0); // constructor
          ~vec();   // destructor
          vec(vec &v1); // copy-initializer
          int length();
          vec& operator=(const vec& v1); // vector assignment
          vec& operator+(const vec& v1); // vector addition
          vec& operator+=(const vec& v1); // vector
additive-assignment
          vec& operator*=(int i); // vector multiply by constant
          // supplied for completeness, but we don't use this now
          int operator*(const vec& v1); // dot product
          vec operator*(int c); // multiply by constant
          // vector transpose multiply needs access to v array
          int operator==(const vec& v1);
          int& operator[](int x);
          friend istream& operator>>(istream& s,vec& v);
          friend ostream& operator<<(ostream& s, vec& v);
}; //vector class

class vecpair;

class matrix {
     protected: 
     // bam_matrix (a derived class) will need to use these members
     // preferred to "friend class", since there may be many
derived
     // classes which need to use this 
          int **m; // the matrix representation
          int r,c; // number of rows and columns
     public: 
          // constructors 
          matrix(int n=ROWS,int p=COLS); 
          matrix(const vec& v1,const vec& v2);
          matrix(const vecpair& vp);
          matrix(matrix& m1); // copy-initializer
          ~matrix();
          int depth();
          int width();
          matrix& operator=(const matrix& m1);
          matrix& operator+(const matrix& m1);
          matrix& operator+=(const matrix& m1);
          vec colslice(int col); 
          vec rowslice(int row); 
          friend ostream& operator<<(ostream& s,matrix& m1);
}; // matrix class

class vecpair {
     friend class matrix;
     friend class bam_matrix;
     friend class bam_system;
          int flag; // flag signalling whether encoding succeeded
          vec a;
          vec b;
     public: 
          vecpair(int n=ROWS,int p=COLS); // constructor
          vecpair(const vec& A,const vec& B);
          vecpair(const vecpair& AB); // copy initializer
          ~vecpair();    
          vecpair& operator=(const vecpair& v1);
          int operator==(const vecpair& v1);
          friend istream& operator>>(istream& s,vecpair& v);
          friend ostream& operator<<(ostream& s,vecpair& v);
          friend matrix::matrix(const vecpair& vp);
};

class bam_matrix: public matrix {
     private: 
          int K; // number of patterns stored in matrix
          vecpair *C; // actual pattern pairs stored
          int feedthru(const vec&A,vec& B);
          int sigmoid(int n); // sigmoid threshold function
     public: 
          bam_matrix(int n=ROWS,int p=COLS);
          ~bam_matrix();
          // but we supply it with the actual matrix A|B (W is
implied)
          void encode(const vecpair& AB); // self-ref version
          // uncode only necessary for BAM-system
          void uncode(const vecpair& AB); // self-ref version
          vecpair recall(const vec& A);
          int check(); 
          int check(const vecpair& AB);
          // Lyapunov energy function: E=-AWBtranspose
          int energy(const matrix& m1); // Lyapunov energy function
}; // BAM matrix

class bam_system {
          bam_matrix *W[MAXMATS];
          int M; // number of matrices
     public:
          bam_system(int M=1);
          ~bam_system();
          void encode(const vecpair& AB);
          vecpair& recall(const vec& A);
          // train equiv. to Simpson's encode of all pairs
          void train(char *patternfile); 
          friend ostream& operator<<(ostream& s,bam_system& b);
}; // BAM system class






