/**********************************************************************
 *  Program Id:     BAKDEL.C                                          *
 *  Author:         Peter M. Perchansky                               *
 *  Copyright:      (c) Peter M. Perchansky 1989                      *
 *  Purpose:        Find and Delete all .BAK & .BK! files.            *
 *  Date Written:   08-17-89                                          *
 *  Date Modified:                                                    *
 **********************************************************************/

/**********************************************************************
 *                        Version History                             *
 *                                                                    *
 *   Version 1.00  08-17-89                                           *
 **********************************************************************/


/* standard includes */
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <direct.h>
#include <dos.h>
#include <string.h>


#define FALSE  0             /* logicals */
#define TRUE   1

#define NAME  13             /* current size of find_t name */


/* function prototypes */
void display_remove_error (char [], char);
void search_directory (char []);
void search_next_directory (char []);
void delete_file (char [], char);
void print_opening (void);
void set_switches (int, char *[]);
void change_to_root (void);
void print_final_results (void);


int  files_deleted = 0;     /* gobal - files deleted */
char search_all = FALSE;    /* gobal - search all directories flag */


main (int argc, char *argv[])
{
    char *name;               /* name setting to delete */

    print_opening ();
    set_switches (argc, argv);

    name = "*.BAK";           /* search for all .BAK files */
    search_directory (name);

    if (search_all)
       search_next_directory (name);

    name = "*.BK!";           /* search for all .BK! files */
    search_directory (name);

    if (search_all)
       search_next_directory (name);

    print_final_results ();
    exit (0);
}


/* print opening lines */
void print_opening(void)
{
    system ("cls");
    printf ("\tDelete .BAK & .BK! Files Utility by Peter M. Perchansky\n");
    printf ("\t        Copyright (c) Peter M. Perchansky 1989\n\n");
}


/* set search_all flag, switch to root if requested */
void set_switches (int argc, char *argv[])
{
    if (argv[argc -1][0] == '/')
    {
	  strupr (argv[argc - 1]);

      if (argv[argc - 1][1] == 'S')
         search_all = TRUE;
	  else
         if (argv[argc - 1][1] == 'A')
         {
            search_all = TRUE;
            change_to_root ();
         }
    }
}


/* change to root directory  */
void change_to_root (void)
{
    if ((chdir ("\\")) != 0)
    {
       printf ("\n\tError changing to root directory.\n");
       exit (1);
    }
}


/* search current directory for matching file specs */
void search_directory (char name[NAME])
{
    struct find_t find;               /* structure of file directory */

    /* find first matching file */
    if (!_dos_findfirst (name, 0xffff, &find))
       delete_file (find.name, find.attrib);

    /* then find addition matching files */
    while (!_dos_findnext (&find))
          delete_file (find.name, find.attrib);
}


/* search subdirectories for zero byte files to delete */
void search_next_directory (char name[NAME])
{
	char  *current_dir;           /* current directory */
	struct find_t find_buffer;    /* file info structure */

	/* get current directory */
	if ((current_dir = getcwd (NULL,0)) == NULL)
	{
	   printf ("\n\tError assigning current directory\n");
	   exit (1);
	}

    /* find the first subdirectory in the current directory */
    _dos_findfirst ("*.*", _A_SUBDIR, &find_buffer);
    if (find_buffer.attrib == _A_SUBDIR && find_buffer.name[0] != '.')
    {
	   if ((chdir (find_buffer.name)) == 0)
          printf ("\n\tSearching %s directory.\n", find_buffer.name);
	   else
	   {
          printf ("\n\tError changing to %s directory.\n", find_buffer.name);
          exit (1);
	   }

	   search_directory (name);
	   search_next_directory (name);

	   /* change back to parent directory */
	   if ( (chdir (current_dir)) != 0)
	   {
          printf ("\n\tError changing back to %s directory.\n", current_dir);
          exit (1);
	   }
    }

    /* find the next subdirectory */
    while (! _dos_findnext (&find_buffer))
          if (find_buffer.attrib == _A_SUBDIR && find_buffer.name[0] != '.')
          {
             if ((chdir (find_buffer.name)) == 0)
                printf ("\n\tSearching %s directory.\n", find_buffer.name);
             else
             {
                printf ("\n\tError changing to %s directory.\n", find_buffer.name);
                exit (1);
             }

             search_directory (name);
             search_next_directory (name);

             /* change back to parent directory */
             if ((chdir (current_dir)) != 0)
             {
                printf ("\n\tError changing back to %s directory.\n", current_dir);
                exit (1);
             }
          }

    free (current_dir);
}


/* delete files found */
void delete_file (char name[NAME], char attrib)
{
    if (!(attrib & _A_SUBDIR))   /* ignore directories */
       if (!(attrib & _A_VOLID)) /* ignore volume */
       {
          if ( (remove (name)) == -1)
             display_remove_error (name, attrib);
          else
          {
             printf ("\t%s deleted.\n", name);
             files_deleted++;
          }
       }
}


/* print file attribute on remove error */
void display_remove_error (char name[NAME], char attrib)
{
	int known_error = FALSE;

	printf ("\n*- Cannot delete %s -*\n", name);

	if (attrib & _A_HIDDEN)
	{
       printf ("\t\t File attribute is hidden.\n");
       known_error = TRUE;
	}

	if (attrib & _A_RDONLY)
	{
       printf ("\t\t File attribute is read-only.\n");
       known_error = TRUE;
	}

	if (attrib & _A_SYSTEM)
	{
       printf ("\t\t File attribute is system.\n");
       known_error = TRUE;
	}

	if (!known_error)
	   printf ("\t\t Unknown error.\n");

	printf ("\n");
}


void print_final_results (void)
{
    if (!files_deleted)
       printf ("\n\tNo .BAK or .BK! files were found to delete.\n");
    else
       printf ("\n\t%d files were deleted.\n", files_deleted);
}
