# Make file for XMS library demonstration program   Michael G.A. Wilson 2/92
# --------------------------------------------------------------------------
# Works with both NMAKE/NMK (Microsoft) and MAKER/MAKE (Borland)
# --------------------------------------------------------------------------

# Definitions
# -----------

PROJECT = XMSTEST

BORLAND = 0         # 0 for Microsoft C, 1 for Borland C++
DEBUG   = 0         # 1 to produce program with CV/TD symbols

!if $(BORLAND)

# Borland-specific

CC      = BCC
LINK    = TLINK
INCPATH = D:\BC\INCLUDE
LIBPATH = D:\BC\LIB
MODEL   = s

!if $(DEBUG)
CFLAGS = -v -D_M_DEBUG
LFLAGS = -v
!else
CFLAGS = -O2
LFLAGS = -x
!endif

!else

# Microsoft specific

CC    = CL
LINK  = LINK
MODEL = S

!if $(DEBUG)
CFLAGS = -W3 -Zp -Od -Zi -D_M_DEBUG
LFLAGS = /CO /NOI
!else
CFLAGS = -W3 -Zp -Ox
LFLAGS = /NOI
!endif

!endif

# Inference rules
# ---------------

.c.obj:
!if $(BORLAND)
  $(CC) -c -I$(INCPATH) -m$(MODEL) $(CFLAGS) {$< }
!else
  $(CC) -c -A$(MODEL) $(CFLAGS) $<
!endif

# Dependency rules
# ----------------

$(PROJECT).exe:  $(PROJECT).obj xmslib.obj
!if $(BORLAND)
  $(LINK) -c -L$(LIBPATH) $(LFLAGS) c0$(MODEL) $**,$(PROJECT),,c$(MODEL)
!else
  $(LINK) $(LFLAGS) $**;
!endif

$(PROJECT).obj:  $(PROJECT).c   xtypes.h  xmslib.h

xmslib.obj:      xmslib.c       xtypes.h  xmslib.h
