/* X M S T E S T . c  -- Demonstration of the XMSLIB functions
 * ---------------------------------------------------------------
 * Michael G.A. Wilson                               February 1992
 * ---------------------------------------------------------------
 */

/* ------------------------  Pragmas -------------------------- */

/* ---------------------- Include files ----------------------- */
#include <stdio.h>  // for FILE, etc
#include <stdlib.h> // for calloc()
#include <string.h> // for strlen()

#include "xmslib.h" // for XMS functions

/* -------------------- Local definitions --------------------- */
#define MAX_LINES    10000  // Longest file allowed (small model)
#define LONGEST_LINE   128  // Longest line allowed in file

/* ------------------- Function prototypes -------------------- */

/* ------------------------- Globals -------------------------- */

/* ------------------------------------------------------------ */

// m a i n
// -------
// Program mainline. List some text files on stdout, after buffering the
// contents in XMS memory. Illustrates use of some XMSLIB functions.
//
// Arguments:
//  <argc>  Number of command line arguments given + 1
//  <argv>  Expected to hold one or more file names: list these files
//          on standard output, after reading them into extended memory.
//
void main (int argc, char **argv)
  {
  if (XMSinstalled() && XMSopen(0))
    {
    // Make a table to store the handles to the strings we'll put in XMS memory
    XMSHANDLE ** HandleBuf = (XMSHANDLE**)calloc(MAX_LINES,sizeof(XMSHANDLE));

    if (HandleBuf != NULL)
      {
      while (argc-- > 1)                                    // For each file...
        {
        FILE * fp = fopen(*++argv, "r");

        if (fp != NULL)
          {
          XMSHANDLE * pH = (XMSHANDLE *)HandleBuf;
          char szLine[LONGEST_LINE];
          unsigned uLineCount = 0;

          puts(strupr(*argv));
          while (fgets(szLine, LONGEST_LINE, fp) != NULL)   // For each line...
            {
            XMSHANDLE hXM;
            size_t uLen = strlen(szLine) + 1;

            if ((hXM = XMSalloc(uLen)) != XMSHNULL &&       // Make XMS space
                 XMSput(hXM, szLine, uLen))                 // Copy to XMS
              *pH++ = hXM;                                  // Store handle
            else
              {
              printf("\n\aXMSalloc() or XMSput() failed.\n");
              break;
              }
            printf("%u\r", ++uLineCount);                   // Show progress
            }

          printf("\n%u lines stored.\n\n", uLineCount);
          fclose(fp);

          pH = (XMSHANDLE *)HandleBuf;                      // Rewind to start

          while (uLineCount-- > 0)
            {
            if (XMSget(szLine, *pH) && XMSfree(*pH++))      // Read line back
              printf("%s", szLine);                         // and free XMS
            else
              {
              printf("\n\aXMSget() or XMSfree() failed.\n");
              break;
              }
            }
          printf("\n----- END OF %s -----\n\n", *argv);
          }
        }
      free(HandleBuf);
      }
    else
      printf("Insufficient memory");

    XMSclose();
    }
  else
    printf("Can't access extended memory.\n");
  }
