#define TURBOC
#include <stdio.h>
#ifdef AMIGA
#include <functions.h>
#endif
#ifdef DATAGENERAL
#include <packets:filestatus.h>
#include <time.h>
#endif
#ifdef TURBOC
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>
#include <stddef.h>
#include <time.h>
#endif
/* definition of whitespace macro */
#define iswhitespace(c) (if((c) == ' ' || (c) == '\n' || (c) == '\011' || (c) == '\014') ? 1L : 0L)
#ifdef AMIGA
struct stat {
	char st_attr;
	long st_mtime;
	long st_size;
	long st_rsize;
};

/* settings of the st_attr field */
#define	ST_DELETE	0x01
#define	ST_EXECUTE	0x02
#define	ST_WRITE	0x04
#define	ST_READ		0x08

/* the format of the st_mtime field is:
	seconds since Jan 1, 1978 */
#endif

/* misc useful definitions */
#define true 1
#define false 0
typedef int BOOL;
#define MAXNAME 50
#define SINGLEQUOTE '\047'

/* important Boolean global states of things */
BOOL needfiledef;
BOOL needmoddef;
BOOL renamefiles;
BOOL updatemode;
BOOL hasauthor;
BOOL dofuncfile;
BOOL displayonly;
BOOL noheader;

/* other important ints */
long flength; /* length of original file in bytes */

/* global character strings - names of stuff */
char author[MAXNAME];
char filename[100];
char newfilename[100];
char funcfile[100];
char LastWord[40];
char revdate[10];
/* and the files themselves */
FILE *fin;
FILE *fout;
FILE *ffunc;

/* the pointers into the buffer containing the input source code */
char *beginning, *current, *marker;

/* some useful character strings */
char *allstars = "**************************************************************";
char *startcomment = "/*+*";
char * endcomment = "*+*/";
char * shortstar = "****";

/* the module definition structure */
#define MAXARGS 20
struct moddef {
        struct moddef *next;
	char name[MAXNAME];
	char *simplename;
	char *offset;
	short numargs;
	short typemask;
	struct argdef {
		char argname[MAXNAME];
		char typestring[40];
		short typemask;
		} args[MAXARGS];
	} *firstdef;
#define STRUCT 0x0001 /*  typemask for is a structure */
#define SHRT 0x0002 /* typemask for is short */
#define LNG 0x0004 /* is long */
#define TYPEINT 0x0008 /* is an int */
#define CHR 0x0010 /* is a character */
#define UNS 0x0020 /* is unsigned */
#define PTR 0x0040 /* is a pointer */
#define FLT 0x0080 /* is floating point */
#define VOID 0x0100 /* void funciton type */
#define HASSTRING 0x0200 /* has a string description (usually structure) */
/* the file definition packet */

struct filedef{
        short numlines;
	char *start;
	char desc[1000];
	} fdef;

/* masks for parsing the c source code file */
#define INCOMMENT 0x0001
#define OUTCOMMENT 0xfffe
#define INDOUBQUOTE 0x0002
#define OUTDOUBQUOTE 0xfffd
#define INSINGQUOTE 0x0004
#define OUTSINGQUOTE 0xfffb

/* function declarations */
void decodeargs(), copytoend(),writemodule(),badnews(),
	dofiledef(),getmoddef(),findmoddef(),renfiles(),dohelp(),writetype();
long filesize();
short setmask();
BOOL copybytes();
char *strchr(),*writeheader();
/*%%*/
/* And here we go */

main(argc,argv)
int argc;
char *argv[];
{
    long offset,bytescopied;
    struct moddef *nextmodule,*prevmodule;
    int err;
    char *cptr;

    offset = bytescopied = 0; /*haven't done anything yet */
    noheader = true;
    decodeargs(argc,argv);
    if(needfiledef) dofiledef();
    if(needmoddef) getmoddef();
    if(updatemode) findmoddef();
   if(!displayonly)
   {
     cptr = writeheader();
     nextmodule = firstdef;
     if(!cptr) cptr = beginning;
     while(nextmodule)
     {
       while( cptr <  nextmodule->offset)
        {
	   err = putc(*cptr,fout);
	   if(err == -1) badnews("Error writing file\n");
	   ++cptr;
        }
        writemodule(nextmodule);
        prevmodule = nextmodule;
      	nextmodule = nextmodule->next;
        free(prevmodule); /* we're done with this data */
     }
     while(cptr < beginning + flength)
        {
	   err = putc(*cptr,fout);
	   if(err == -1) badnews("Error writing file\n");
	   ++cptr;
        }
   } /* end of if not displayonly */
    if(renamefiles) renfiles();
    if(beginning) free(beginning);
}

void badnews(mesg)
char *mesg;
{
  printf("Bad news! %s\n",mesg);
  exit(1);
}

void decodeargs(argc,argv)
int argc;
char *argv[];
{
  register short i;
  BOOL OK;
  char *firstcptr,firstchar;
  void GetDate();

  /* the intial state of things */
  hasauthor = false;
  needfiledef = false;
  updatemode = true;
  dofuncfile = false;
  renamefiles = false;
  needmoddef = true;
  displayonly = false;
  fin = fout = ffunc = (FILE *)NULL;  

  for(i=1;i<argc;++i)
  {
    if(*argv[i]=='-')   /* switch argument */
    {
        firstcptr = ++argv[i];
        firstchar = toupper( *firstcptr);
        switch (firstchar)
        {
            case 'A':
                ++firstcptr;
                strncpy(&author[0],firstcptr,30);
                hasauthor = true;
                break;

            case 'F':
                ++firstcptr;
		if(*firstcptr)
		{
                  strncpy(&funcfile[0],firstcptr,100);
                  ffunc = fopen(&funcfile[0],"a");
	        }
                dofuncfile = true;
                break;

            case 'X':
                 ;
                break;

            case 'N':
                ++firstcptr;
                strncpy(&newfilename[0],firstcptr,100);
                fout = fopen(&newfilename[0],"w+");
		break;

            case 'I':
                updatemode = false;
                break;

	    case 'V':
	        displayonly = true;
		break;

	    case 'D':
		++firstcptr;
		strncpy(&revdate[0],firstcptr,8);
		break;

        } /*end of switch on switches */
    } /* end of if arg starts with a '-'*/
    else if(fin)
    {
      /* input filename already open so they screwed up */
      dohelp("Two input files specified. I handle only 1");
    }
    else
    { /* got a filename - open it */
         strncpy(&filename[0],argv[i],100);
         if(!(fin = fopen(&filename[0],"r+")))
                {
                    printf("Could not open input file %s \n",&filename[0]);
                    exit(1);
            }
    }
  } /* for loop */
     if(!fin) dohelp("No file specified.\n"); /*no input file specified */
     if(displayonly) 
	{ updatemode = true;
	  renamefiles = false;
	}
     if(!fout) 
          {
             fout = fopen("tempout","w+");
             strcpy(&newfilename[0],"ram:tempout");
             renamefiles = true;
        }
     flength = filesize(&filename[0]);
     printf("Input file is %dL bytes long.\n",flength);
     if(flength <0) 
	exit(1);
     if(dofuncfile && !ffunc)
       { /* open default functionfile - filename.h */
          strncpy(&funcfile[0],&filename[0],100);
	   funcfile[strlen(funcfile)-1] = 'h';
             if(!(     ffunc = fopen(&funcfile[0],"a")))
	 	printf("Warning! could not open function file %s\n",
			&funcfile[0]);
       }

     if(!(beginning = (char *)calloc(flength,1)))
	{ dohelp("Not enough memory to read source file.\n");
	}
     checkforheader();
     if(!hasauthor && !displayonly)
	{ printf("Author? ");
	  gets(&author[0]);
	}
     if(updatemode)
	{
	   needfiledef = false;
	   needmoddef = false;
	}
      if(!revdate[0])
	GetDate(&revdate[0]);

}


checkforheader()
{
    needfiledef = true;
}

#ifdef DATAGENERAL

long filesize(fname)
char *fname;
{
    P_FSTAT fstat_pack,*AC2;
    long AC1,size;

    AC1 = 0;
    AC2 = &fstat_pack;
    size =(sys($FSTAT,&fname,&AC1,&AC2) ? 1L : fstat_pack.sefm);
    return(size); 
}

void GetDate(string)
char *string;
{ struct tm *now; 

   now = dg_localtime (0L);   /* first get todays date/time info */
   sprintf(string,"%02d/%02d/%02d",(now->tm_mon+1),now->tm_mday,
             (now->tm_year % 100));
}

#endif
#ifdef AMIGA

long filesize(fname)
char *fname;
{
    struct stat fstat_pak;
    long size;

    if((stat(fname,&fstat_pak)) != -1) return(fstat_pak.st_size);
    else
       return(1);

}
#endif
#ifdef TURBOC

long filesize(fname)
char *fname;
{
int fp;
long flen;

  fp=open(fname,O_RDONLY);
  if (fp==-1)
    return(1);
  else {
    flen = filelength(fp);
    close(fp);
    return(flen);
  }
}

void GetDate(string)
char *string;
{
 struct tm *now;
 time_t t;

   t   = time(NULL);
   now = localtime (&t);   /* first get todays date/time info */
   sprintf(string,"%02d/%02d/%02d",(now->tm_mon+1),now->tm_mday,
            (now->tm_year % 100));
}

#endif

void dohelp(cptr)
char *cptr;
{
   printf("%s\n",cptr);
   printf("Usage: autodoc filename [options]\n   Where options are:\n");
   printf("   -aauthor\n");
   printf("   -f[functionfilename]   writes function declaration file\n");
   printf("   -v      display only (lists undocumented functions)\n");
   printf("   -i      input data from keyboard instead of updating file\n");
   printf("   -nnewfilename    writes output to newfilename\n");
   printf("   -dMM/DD/YY  use MM/DD/YY as release date\n");
   if(beginning) free(beginning);
   exit(1);
}



void dofiledef()
{
    char linebuffer[200],*cptr;
    short i,ilen;
    long readerr;
    BOOL more;
	
    i=1;
    printf("Enter description for file %s\n",&filename[0]);
    cptr = &fdef.desc[0];
    more = true;
    do
       {
	  printf("%3d) ",i);
	  gets(cptr);
	  if( ilen = strlen(cptr))
		{ cptr += ilen+1;
         		 ++i;
         	 ++ fdef.numlines;
	  	}
	  else
	  {
	  	more = false;
	  }
	}
    while(more);
 }


char *writeheader ()
{
    struct moddef *nextmodule;
    short i;
    char *cptr;
    
 if(noheader)
  {
     fprintf(fout,"%s%s\n%s\n",startcomment,allstars,shortstar);
       fprintf(fout,"%s File %s by  %s  Created %s\n",shortstar,&filename[0],
		&author[0],&revdate[0]);
     if(ffunc)
	fprintf(ffunc,"/***** Function declarations for %s ****/\n",
	      &filename[0]);	    
    for(i=0,cptr = &fdef.desc[0]; i< fdef.numlines; ++i)
    {
    	fprintf(fout,"%s    %s\n",shortstar,cptr);
    	cptr += strlen(cptr)+1;
    }
        
    fprintf(fout,"%s\n%s   Contains functions: \n%s    ",
	  shortstar,shortstar,shortstar);
     cptr = (char *)0;
  } /* end of noheader at all */
  else /* there is a header */
   { cptr = beginning;
     while(cptr < fdef.start)
	{ putc(*cptr,fout);
	  ++cptr;
	}
     if(firstdef)
	fprintf(fout,"%s    ",shortstar);

    }
    nextmodule = firstdef;
    while(nextmodule)
    {

       if(noheader)
         fprintf(fout,"%s() \n%s   ",&nextmodule->name[0],shortstar);
       else
	 fprintf(fout,"%s() added %s\n%s    ",&nextmodule->name[0],
		&revdate[0],shortstar);
       if(ffunc)
         fprintf(ffunc,"%s ();\n",&nextmodule->name[0]);
      	nextmodule = nextmodule->next;
    }
    if(!cptr)
     fprintf(fout,"\n%s\n%s%s\n",shortstar,allstars,endcomment);
     return (cptr);
}

void copytoend()
{
;
}

struct moddef *makemodule(linebuf,startofline)
char *startofline;
char *linebuf;
{ char *cptr1,*cptr2,*cptr3;
  static char simplename[30];
  short slen,namelen;
  struct moddef *mod,*prevmod;
	cptr1 = current -1;
	namelen = min(cptr1 - linebuf,MAXNAME);
	while(*cptr1 == ' ' || *cptr1 == '\011')
	   --cptr1;
	cptr2 = cptr1;
	while(*cptr1 != ' ' && *cptr1 != '\011' &&
		*cptr1 != ',' && *cptr1 != '\n')
	   --cptr1;
        for(cptr3 = cptr1+1,slen=0; cptr3 <= cptr2;++slen, ++cptr3)
             simplename[slen] = *cptr3;
	simplename[slen] = '\0';
	/* now check to see if we already used this simple name */
	prevmod = mod = firstdef;
	while(mod)
	{
	  if(!(strcmp(mod->simplename ,&simplename[0]))) break;
	  prevmod = mod;
	  mod = mod->next;
	}
	if(!mod)
	{
	    mod = calloc(sizeof(struct moddef),1);
	    if(prevmod) prevmod->next = mod;
	    else firstdef = mod;
	}
        for(cptr3 = linebuf,slen=0,++cptr1; cptr3 <= cptr2;++slen, ++cptr3)
	{  mod->name[slen] = *cptr3;
	   if(cptr3 == cptr1) mod->simplename = &mod->name[slen];
        }
	mod->numargs = 0;
	mod->offset = startofline;
	printf(" Found function %s\n",mod->simplename);
	return(mod);

}


void processword(curmod,wordstack,type,lastchptr)
struct moddef *curmod;
char *wordstack,*lastchptr;
short *type;
{
BOOL isvar;
short i;
char *cptr,cword[40];

	for(cptr = &cword[0];wordstack < lastchptr;++wordstack,++cptr)
	{ *cptr = *wordstack;
	}
	*cptr = '\0';
	if(!strcmp(&cword[0],"short"))
	   *type |= SHRT;
        else if(!strcmp(&cword[0],"long"))
	   *type |= LNG;
        else if(!strcmp(&cword[0],"struct"))
	   *type |= STRUCT;
        else if(!strcmp(&cword[0],"char"))
	   *type |= CHR;
	else if(!strcmp(&cword[0],"int"))
	   *type |= TYPEINT;
	else if(!strcmp(&cword[0],"*"))
	   *type |= PTR;
	else if(!strcmp(&cword[0],"unsigned"))
	   *type |= UNS;
	else
	{
	   isvar = false;
	   for(i=0; i<curmod->numargs && !isvar; ++i)
	   {
	     if(!strcmp(&cword[0],curmod->args[i].argname))
		{
			curmod->args[i].typemask = *type;
		        isvar = true;
		        if(*type & HASSTRING)
		          strcpy(&curmod->args[i].typestring[0],
				     LastWord);
		}
	    }
	    if(!isvar)
		{ strcpy(LastWord,&cword[0]);
		  *type |= HASSTRING;
		}
	}
}

void findmoddef()
{
    short slen,level,currenttype;
    register short InFlag;
    struct moddef *curmod;
    BOOL indef,makingmodule,FoundStart,typingargs;
    BOOL foundfuncheader,inblockcomment;
    char *cptr,stack,*startofline,*argptr,*startofmod,*wordstack;
    
    InFlag = indef = makingmodule = typingargs = 0;
    foundfuncheader = inblockcomment = 0;
    currenttype = 0;
    current = beginning;
    stack = 0;
    level = 0;
    inblockcomment = 0;
    FoundStart = false;
    while(fgets(current,500,fin))
	{
          startofline = current;
	  startofmod = startofline;
	  indef = false; /* assumes only one line macros */
	  while(*current)
	  {
	   if(InFlag) /* we are inside a comment, a single quote or a double
			quote */
	     {
	      switch (*current)
	      {
	         case '/':
		     if(stack == '*' && (InFlag & INCOMMENT))
		        {InFlag = 0; /* clear comment */
			 if(!FoundStart && inblockcomment)
				fdef.start = startofline;
			 inblockcomment = false;
			}
		     break;
		 case '"':
		      if(InFlag & INDOUBQUOTE)
			 InFlag = 0; /* clear double quote */
		      break;
		 case SINGLEQUOTE:
		      if(InFlag & INSINGQUOTE)
			InFlag = 0; /* clear single quote */
		      break;
	         case '%':
	             if(InFlag & INCOMMENT && stack == '%')
			FoundStart = true;
		     break;
	         case '+':
	             if(InFlag & INCOMMENT && stack == '*')
			inblockcomment = true;
		     if(inblockcomment && !FoundStart)
		        noheader = false;
		     if(inblockcomment && level == 0 && FoundStart)
			foundfuncheader = true;
		     break;
	        } /*end of switch */
	     } /* end of if inside something */
		else /* not inside something */
	    {
		 switch (*current)
		 {
    		    case '*':
 		      if(stack == '/')
			InFlag |= INCOMMENT;/*set comment flag */
		      else if (typingargs)
			currenttype |= PTR;
		     break;
      		    case '#':
		     if(stack == '\n')
			indef = true;
		     break;
		    case '{':
		      ++level;
		      typingargs = false;
		      foundfuncheader = false;
		      break;
		     case '}':
		       --level;
			break;
	             case SINGLEQUOTE:
			InFlag |= INSINGQUOTE;
			break;
		     case '"':
			InFlag |= INDOUBQUOTE;
			break;
		     case '(':
		        if (level == 0 && !indef && FoundStart &&
				 !foundfuncheader && !typingargs)
			  {
			     makingmodule = true;
			     curmod = makemodule(startofmod,startofline);
			     argptr = &curmod->args[0].argname[0];
			  }
          		 ++ level;
			break;
		     case ')':
			startofmod = current+1;
			if(makingmodule)
			  {
			    wordstack = current;
			    typingargs = true;
			  }
			makingmodule = false;
			-- level;
	                break;
		     default :
		 	if(makingmodule)
			{
			  if(isalpha(*current))
			   { if(argptr == &curmod->args[0].argname[0])
				curmod->numargs = 1;
			     *argptr = *current;
			     ++argptr;
			   }
			  else if(*current == ',')
			   {
			      *argptr = '\0';
		 	      argptr =
				   &curmod->args[curmod->numargs].argname[0];
			      ++curmod->numargs;
			   }
			} /* end of if makingmodule */
		        else if(typingargs)
			{
			  if(!isalpha(*wordstack))
				wordstack = current; /* ignore leading
							whitespace */
			  else
			     { if (!isalpha(*current) && *current != '*')
				{
				 processword(curmod,wordstack,&currenttype,
				      current);
				 wordstack = current;
				}
				if(*current == ';') currenttype = 0;
			     }
			} /* end of typing args */
	                break; /* end of default case */
                   } /* end of switch on current */
	         } /* end of else implying not inside something */
		 stack = *current;
                 ++current;

	      } /* end of while more data in line to process
            } /* end of more data to read */
	}
}

void getmoddef()
{
    struct moddef *next,*previous;
    char linebuffer[100],*cptr,*typeptr,*nameptr;
    short i,j,ich;
    BOOL morefuncs,moreargs;

    /* first find the end of the module definition list */
    previous = firstdef;
    while(previous && previous->next)
    {
	previous = previous->next;

    }

    /* keep accepting definitions for modules until they don't want any more */
    morefuncs = true;
    printf("First enter the modules that you want to add documentation for\n\n");
    j=1;
    while(morefuncs)
    {
	printf("Enter the name for module %d :",j++);
	gets(linebuffer);
        if(linebuffer[0])
	{
	    next = (struct moddef *)calloc(sizeof(struct moddef),1);
	    if (previous) previous->next = next;
	    else
		{ previous = next;
		  firstdef = next;
		}
	    if(linebuffer[0] == '-')
	      {
	       cptr = strchr(&linebuffer[1],' ');
	       if(cptr)
	        {
		 nameptr = cptr+1;
		 *cptr = '\0';
	         typeptr = &linebuffer[1];
		}
	        else
		{
		 nameptr = &linebuffer[0];
		 typeptr = (char *) 0 ;
	        }
	       }
	    else
		{
		 nameptr = &linebuffer[0];
		 typeptr = (char *) 0;
	        }

	    strncpy(&next->name[0],nameptr,MAXNAME);
	    if(!typeptr)
	      { printf("Type function (i,s,l,c,f and/or u) : ");
	       gets(linebuffer);
	       typeptr = &linebuffer[0];
	      }
	    next->typemask = setmask(typeptr);
	    /* now keep accepting argument definitions until done */
	    i=0;
	    moreargs = true;
	    while(moreargs && i < MAXARGS)
	    {
	        printf("\n Enter the name for argument %d: ",i+1);
	      gets(linebuffer);
	      if(linebuffer[0])
	      {
	       	if(linebuffer[0] == '-')
	        {
	         cptr = strchr(&linebuffer[1],' ');
     	         if(cptr)
       	          {
         	   nameptr = cptr+1;
	   	   *cptr = '\0';
	           typeptr = &linebuffer[1];
	       	  }
	          else
	   	  {
	     	   nameptr = &linebuffer[0];
	       	   typeptr = (char *) 0;
	          }
	       	 }
	     	else
		{
	      	  nameptr = &linebuffer[0];
	       	  typeptr = (char *) 0;
	        }
		   strncpy(&(next->args[i].argname[0]),nameptr,MAXNAME);
	           if(!typeptr)
		    {
 	              printf("Type argument (i,s,l,c,f and/or u) : ");
		       gets(linebuffer);
		       typeptr = &linebuffer[0];
		    }
		   next->args[i].typemask = setmask(typeptr);
		   ++next->numargs;
		 }
	      else
		moreargs = false;
	      ++i;
	      } 
	} /* input to functions */
	else
	   morefuncs = false;
      }

}

void renfiles()
{
;
}

short setmask(cptr)
char *cptr;
{
    short mask;
    mask = 0;
	    while(*cptr)
	     {
		switch(tolower(*cptr))
		{
		  case 'i':
		    mask |= TYPEINT;
		    break;
		  case 's':
		    mask |= SHRT;
		    break;
		  case '*':
		    mask |= PTR ;
		    break;
		  case 'f':
		    mask |= FLT;
		    break;
		  case 'u':
		    mask |= UNS;
		    break;
		  case 'c':
		    mask |= CHR;
		    break;
		  case 'v':
		    mask |= VOID;
		    break;
		}
	      ++cptr;
	    } /* end of while cptr */
	return (mask);
}



void writemodule(module)
struct moddef *module;
{
   short i;
   fprintf(fout,"%s%s\n%s\n%s   ",startcomment,allstars,shortstar,shortstar);
    writetype(module->typemask,fout);
    fprintf(fout,"%s (",&module->name[0]);
    for	(i=0;i<module->numargs;++i)
    {
	writetype(module->args[i].typemask,fout);
	if(module->args[i].typemask & HASSTRING)
	  {
	     fprintf(fout,"%s ",&module->args[i].typestring[0]);
	     if(module->args[i].typemask & PTR)
		fprintf(fout,"*");
	  }
	fprintf(fout,"%s",
		&(module->args[i].argname[0]));
	if(i+1 < module->numargs)
		fprintf(fout,",\n%s              ",shortstar);

    }
     fprintf(fout,")\n%s",shortstar);
    fprintf(fout,"\n%s\n%s    Author: %s\n",shortstar,
        shortstar,&author[0]);
    fprintf(fout,"%s    Revision History:\n%s    %s Original Release\n%s\n%s%s\n\n",
	shortstar,shortstar,&revdate[0],
	shortstar,allstars,endcomment);

}


void writetype(mask,f)
short mask;
FILE *f;
{
    if (mask & UNS)
	fprintf(f,"unsigned ");
    if (mask & LNG)
	fprintf(f,"long ");
    if (mask & SHRT)
	fprintf(f,"short ");
    if (mask & TYPEINT)
	fprintf(f,"int ");
    if (mask & CHR)
	fprintf(f,"char ");
    if (mask & FLT)
	fprintf(f,"float ");
    if (mask & VOID)
	fprintf(f,"void ");
    if (mask & STRUCT)
	fprintf(f,"struct ");
    if (mask & PTR && !(mask  & HASSTRING))
	fprintf(f,"*");

}



BOOL copybytes(numbytes)
long numbytes;
{;
 return (true);
}
