/*
	Simple-Term

	A short terminal emulation package to show the use of the
	ASYNC communications library.

	In case you are wondering, the COM Port settings are hard coded in
	the defines right before main(), change these as you wish.

	Also, this program does not emulate any known terminal.  Instead
	it outputs all text via DOS, so if you run ANSI.SYS then you can
	have a more useable program-- but since this is an example anyway, 
	I sure you don't mind.  
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "async.h"

#define	COM_PORT	COM1
#define BAUD_RATE	38400
#define	COM_SETTINGS	(BITS_8 | STOP_1 | NO_PARITY)

int	main()
{
int	c;

printf( "Simple-Term.  Press F10 to Quit.\n\n");

if( AsyncInit( COM_PORT))
	{
	printf( "Error initalizing COM Port.\n");
	return(1);
	}

AsyncSet( BAUD_RATE, COM_SETTINGS);
AsyncHand( DTR | RTS);

for(;;)
	{
	/*	If a character was recieved, print it to the console */
	if( (c=AsyncIn())!=0)
		putch( c);

	/*	If a key has been pressed	*/
	if( kbhit() )
		{
		c=getch();
		if( c==0)	/* Check for 'extended characters */
			{
			c=getch();	/* Get the extended code */
			if( c==0x44)	/* Exit if it is a F10 */
				break;
			}
		else
			AsyncOut(c);
		}

	/*	If the buffer has a lot in it, drop RTS and empty the buffer */
	if( AsyncInStat()>4096)
		{
		AsyncHand( DTR);	/* Drop RTS */
		while( AsyncInStat()>0)
			putch( AsyncIn() );
		AsyncHand( DTR | RTS);
		}
	}

AsyncStop();
return(0);
}
