/*
 *  asc2wp - ascii to word-processor
 *      by Gene Johannsen
 */

#include "asc2wp.h"

void main(int argc, char *argv[])
{
int spacing=ON;
int tabs=OFF;
int filecount=0;

FILE *fp_in;
FILE *fp_out;
FILE *fp_tmp1;
FILE *fp_tmp2;

char filenames[3][80];
char tmpname1[7] = "XXXXXX";
char tmpname2[7] = "XXXXXX";

/*
 *  Get the options and file names from the comand line
 */

  if (argc == 1)
  { help();
    exit (1);
  }
  while (--argc > 0)
  { if ((*++argv)[0] == SWITCH)
    { while (*++(*argv))
      { switch (**argv)
        {  case 's': toggle(spacing); break;
           case 't': toggle(tabs); break;
           default: help(); exit (1);
        }
      }
    }
    else
    { strcpy (filenames[filecount], *argv);
      if (++filecount == 3)
      { printf ("Too many files specified on command line");
        exit (1);
      }
    }
  }
  if (filecount == 1)
  { printf ("Too few files specified on command line");
    exit(1);
  }
  if (!strcmp(filenames[0], filenames[1]))
  { printf ("File names must be different");
    exit (1);
  }

/*
 *  Open files
 */
  if ((fp_in=fopen (filenames[0], "r")) == NULL)
  { printf("Cannot open %s for input", filenames[0]);
    exit (1);
  }
  if ((fp_out=fopen (filenames[1], "w")) == NULL)
  { printf ("Cannot open %s for output", filenames[1]);
    exit (1);
  }
  mktemp(tmpname1);
  mktemp(tmpname2);
  if ((fp_tmp1=fopen (tmpname1, "w+")) == NULL)
  { printf ("Cannot open a temporary file for output");
    exit (1);
  }
  if ((fp_tmp2=fopen (tmpname2, "w+")) == NULL)
  { printf ("Cannot open a temporary file for output");
    exit (1);
  }

/*
 *  Call the passes
 */
  pass_one(fp_in, fp_tmp1);
  rewind(fp_tmp1);
  pass_two(fp_tmp1, fp_tmp2, tabs);
  rewind(fp_tmp2);
  remove(tmpname1);
  pass_three(fp_tmp2, fp_out, spacing);
  remove(tmpname2);
}