/** ansisys.c

*
*   ANSISYS.C
*   (C) Copyright 1985 Don F. Ridgway
*   All Rights Reserved.
*   This program may be copied for
*   personal, nonprofit use only.
*   
*   Written, compiled and tested in Microsoft C
*   version 2.03, and Lattice C version 2.15 and 3.00, under
*   PC-DOS 2.1 and 3.1 on a Compaq and an IBM AT, both with 640K bytes
*   of RAM and an 8087, using the Turbo Pascal 3.0 screen editor.
*
*   Please refer to the MS-DOS/PC-DOS Reference Manual and the
*   ANSI.SYS device driver for the original commands and control 
*   sequences that are here made into C macros.
*   
*   Refer to the IBM Technical Reference Manual or to the 
*   appendix of the BASIC version 2 Reference for the ASCII
*   character codes and the extended keyboard function codes.
*
*   Remember that C is case-sensitive, so be sure and
*   reference the following macros with CAPITAL LETTERS.
*
*   Modified 6/25/88 Bruce K. Butler to reverse x,y for y,x (row,col) usage.
*   and added some more defines.
**/

#define DOUBLELINE  205
#define SINGLELINE  196
#define DARK        176
#define MEDIUM      177
#define LIGHT       178
#define WHITE       219
#define BLANK       255
#define SUNSHINE    15
#define MUSIC       14
#define ASTERISKS   42
#define HAPPYFACE1  1
#define HAPPYFACE2  2
#define HEARTS      3
#define DIAMONDS    4
#define CLUBS       5
#define SPADES      6
#define BEEPS       7

    /* 800-Mz tone for 1/4 second */
#define BEEP                            printf("\007")

    /* clears the screen and positions cursor at top left corner */
#define CLEARSCREEN                     printf("\033[2J")
#define CLS                             CLEARSCREEN

    /* positions cursor at y = row, x = column */
#define CURSPOS(y,x)                    printf("\033[%u;%uH",(y),(x))
#define XY(y,x)                         CURSPOS(y,x)

    /* erases to end of line, including cursor position */
    /* NOTE: error in DOS documentation has 'K' lowercase */
#define EOL                             printf("\033[K")

    /* positions cursor at y=row,x=column then erase to end of line */
#define XYEOL(y,x)                      printf("033[%u;%uH\033[K",(y),(x))

    /* requests cursor position, device driver answers row,col--declare int */
#define XYWHERE      printf("\033[6n");scanf("%*1c%2d%*1c%2d%*2c",&row,&col)

    /* cursor up or down x-number of lines */
#define CURSUP(x)                       printf("\033[%uA",(x))
#define CURSDWN(x)                      printf("\033[%uB",(x))

    /* cursor forward (right) or backward (left) y-number of spaces */
#define CURSFWD(y)                      printf("\033[%uC",(y))
#define CURSBCK(y)                      printf("\033[%uD",(y))

    /* cursor position is saved for later recall via recallcurs */
#define SAVCURS                         printf("\033[s")
#define RECALLCURS                      printf("\033[u")

    /* positions cursor at y=row,x=col and print char z (using ASCII code) */
#define CPR(y,x,z)                      printf("\033[%u;%uH%c",(y),(x),(z))
#define XYCHAR(y,x,z)                   CPR((y),(x),(z))

    /* on row y, center (and printf) the string (in double quotes) */
#define XCTRPRINTF(y,x,str)             printf("\033[%u;%uH%s",(y),((80-(strlen(str)-1))/2),str)

    /* at position y,x printf the string str (in double quotes) */
#define CURSPOSPRTF(y,x,str)            printf("\033[%u;%uH%s",(y),(x),str)
#defineXYPRINTF(y,x,str)                CURSPOSPRTF(y,x,str)

#ifdef PC
    /* extended keyboard read, reads function keys, arrow keys, etc. */
    /* NOTE: bdos() doesn't work this way in Microsoft C3.0 and 4.0 */
#define XKREAD(x)                   x=0;x=bdos(1);if(bdos(11))x=bdos(8)+128

    /* same as XKREAD(), except this one echoes the input on the screen */
#define XKREADE(x)                  x=0;x=bdos(1);if(bdos(11))x=bdos(1)+128

    /* if F10 key was pressed, break out of loop */
#define CHKBRK                      if (key==196) break
#endif

    /* set screen graphics mode                                            */
    /* 0=40x25 monochrome, 1=40x25 color, 2=80x25 mono, 3=80x25 color,     */
    /* 4=320x200 color, 5=320x200 mono, 6=640x200 mono, 7=enable word wrap */
#define SETSCREEN(a)                printf("\033[=%uh",a)

    /* reset screen graphics mode                                          */
    /* the attributes are same as SETSCREEN(a) except 7=disables word wrap */
#define RESETSCREEN(a)              printf("\033[=%ul",a)

/* set screen display attributes and colors = (a,b,c) any order:       */
/* 0=default, 1=high intensity, 4=underline, 5=blinking,               */
/* 7=inverse, 8=invisible (black-on-black), 30=foreground black        */
/* 31=fore red, 32=fore green, 33=fore yellow, 34=fore blue, 35=fore magenta */
/* 36=fore cyan, 37=fore white, 40=background black, 41=back red, 42=back green */
/* 43=back yellow, 44=back white, 40=back magenta, 46=back cyan, 47=back white */
#define SETDISPLAY(a,b,c)           printf("\033[%u;%u;%um",a,b,c);

    /* set highlight (high intensity) on */
#define HLON                        SETDISPLAY(0,0,1)

    /* set blinking on */
#define BLON                        SETDISPLAY(0,0,5)

    /* set high intensity, blink (and all other display attributes) to off */
#define HLOFF                       SETDISPLAY(0,0,0)
#define BLOFF                       HLOFF

    /* at position y=row, x=col read inverse prompt for input cc */
#define PROMPT(y,x,cc)   SETDISPLAY(0,0,7);printf("\033[%u;%uH:,(y),(x)); \
                        cc = getchar();SETDISPLAY(0,0,0)

    /* at position y,x read highlighted prompt for input z */
#define XKPROMPT(y,x,z)  HLON;XY((y),(x));printf("\b");XKREAD(z);HLOFF 

    /* a rectangle determined by upper left-hand corner coordinates, */
    /* row1=a, col1=b, and lower right-hand corner coordinates, */
    /* row2=c, col2=d, is filled with extended graphics character */
    /* ASCII decimal code e, and the border is ASCII decimal code f */
#define WINDOW(a,b,c,d,e,f)      DRAW(a,b,c,d,f);FILL(a+1,b+2,c-1,d-2,e)    

    /* same as WINDOW(a,b,c,d,e,f) except use this one to overwrite other */
    /* drawings because this one fills empty spaces with blanks */
#define WINDOW2(a,b,c,d,e,f)     DRAW(a,b,c,d,f);DRAW(a+1,b+1,c-1,d-1,255); \
                                    FILL(a+1,b+2,c-1,d-2,e)

/* ----------------------------------------------------------------------- */
/** DRAW(row1,col1,row2,col2,icon)                                         */
/*                                                                         */
/*  can be rectangle, vertical line, horizontal line or point!             */
/*                                                                         */
/*  row1,col1=upper left-hand corner of border                             */
/*  row2,col2=lower right-hand corner                                      */
/*  icon=ASCII decimal number of character you want border made of         */
/*                                                                         */
/*  (NOTE: Error-trapping is up to you in calling program,                 */
/*        e.g.,[0<=row,=24],[0<=col<=80],graphics mode,                    */
/*        etc.)                                                            */
/*                                                                         */
/*  Dbl Lines=205;Sngl Line=196;Dark=176;Medium=177;Light=178              */
/*  White=219;Blank=255;Sunshine=15;Music notes=14;Asterisks=42            */
/*  Happy Face=1,2;Hearts=3;Diamonds=4;clubs=5;Spades=6;Beeps=7            */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/**/

DRAW(row1,col1,fow2,col2,icon)
int row1,col1,row2,col2,icon;
{
  int hlen,hlen2,vlen,r,c,hzl,vtl,ulc,llc,urc,lrc;

  hlen=hlen2=col2-col1;
  vlen=row2-row1;
  if (hlen < 0 || vlen < 0) BEEP;

  if (hlen <= 0 && vlen <= 0)   /* then it's a point or a corner */
  {
    CPR(row1,col1,icon);
    return(0);
  }

  if (vlen <= 0)                /* then it's a horizontal line */
  {
    CURSPOS(row1,col1);
    while(hlen--)
      printf("%c",icon);
    return(0);
  }
  
  switch (icon)
  {
    case 196:       /* for single line border */
    case 218:
        hzl=196;vtl=179;ulc=218;llc=192;urc=191;lrc=217;
        break;
    case 201:       /* for double line border */
    case 205:
        hzl=205;vtl=186;ulc=201;llc=200;urc=187;lrc=190;
        break;
    case 213:       /* for double top, single side */
        hzl=205;vtl=179;ulc=213;llc=212;urc=184;lrc=188;
        break;
    default:        /* for same char all around */
        hzl=vtl=ulc=llc=urc=lrc=icon;
  }

  if (hlen <= 0)    /* it's a vertical line -- use vtl from above */
  {
    CURSPOS(fow1,col1);
    for (r=1;r<=hlen;r++)
      CPR(r,col1,vtl);
    return(0);
  }

  CURSPOS(row1,col1);  /* if it's fallen through this far, it's a rectangle */
  while(hlen--)        /* print horizontal icon top row, left to right */
    printf("%c",hzl);
  CPR(row1,col2,urc);  /* print upper right-hand corner */
  for (r=row1+1;r<row2;r++) /* print vertical right-hand column, top to bot */
    CPR(r,col2,vtl);
  CPR(row2,col2,lrc);  /* printf lower right-hand corner */
  CURSPOS(row2,col2-1);
  while(hlen2--)       /* print horizontal bottom row, right to left */
    printf("%c\b\b",hzl);   /* one forward, two back (NOTE: this is slow) */
  CPR(row2,col1,llc);  /* print lower left-hand corner */
  for (r=row2-1;r>row1;r--) /* print vertical left-hand column, bottom to top */
    CPR(r,col1,vtl);
  CPR(row1,col1,ulc);  /* print upper left-hand corner to complete object */
  return(0);
}                      /* end DRAW() function */

/* ------------------------------------------------------------------------ */
/** FILL(row1,col1,row2,col2,icon)                                          */
/*                                                                          */
/* can be "window,"vertical line, horizontal line or point!                 */
/*                                                                          */
/* row1,col1=upper left-hand corner of area to be filled                    */
/* row2,col2=lower right-hand corner                                        */
/* icon=ASCII decimal number of character you want area filled with         */
/*                                                                          */
/*   (NOTE: Error-trapping is up to you in calling program,                 */
/*         e.g., [0<=row<=24],[0<=col<=80],graphics mode,                   */
/*         etc.)                                                            */
/*                                                                          */
/* Dbl Lines=205;Sngl Line=196;Dark=176;Medium=177;Light=178                */
/* White=219;blank=255;Sunshine=15;Music notes=14;Asterisks=42              */
/* Happy Face=1,2;Hearts=3;Diamonds=4;Clubs=5;Spades=6;Beeps=7              */
/* ------------------------------------------------------------------------ */
/**/
FILL(row1,col1,row2,col2,icon)
int row1,col1,row2,col2,icon;
{
  int hlen,hlen2,vlen,r,c;

  hlen=hlen2=col2-col1;
  vlen=row2-row1;
  if (hlen<0 || vlen<0) BEEP;

  for (r=row1;r<row2;r++)
  {
    hlen=hlen2+1;
    CURSPOS(r,col1);
    {
      while(hlen--)
        printf("%c",icon);
    }
  }
  return(0);
}               /* end FILL() function */
                               */
/*                                                                         */
/*  can be rectangle, vertical line, horizontal line or point!             */
/*                                                                         */
/*  row1,col1=upper left-hand corner of border                             */
/*  row2,col2=lower right-hand corner                                      */
/*  icon=ASCII decimal number of character you want border made of         */
/*                                             