// ex09010
// Header file to redefine the time classes with virtual functions
// ---------- times.h

#ifndef TIMES_H
#define TIMES_H

#include <iostream.h>
#include <stdio.h>

//
// A Time Class
//

class Time	{
	int hours, minutes, seconds;
public:
	Time(int hr, int min, int sec)
		{ hours = hr; minutes = min; seconds = sec; }
	virtual void display()
		{ cout << hours << ':' << minutes << ':' << seconds; }
};

//
// A TimeZone Class
//
enum timezone { gmt, est, cst, mst, pst };
char *TZ[] = { "GMT", "EST", "CST", "MST", "PST" };

class TimeZone	: public Time {
protected:
	 timezone zone;
public:
	TimeZone(int hr, int min, int sec, timezone zn) 
			: Time(hr, min, sec)
		{ zone = zn; }
	virtual void display()
		{ Time::display(); cout << ' ' << TZ [zone]; }
};



//
// A DispTime Class
//

inline int adjust(int hour)
{	return hour > 12 ? hour - 12 : (hour == 0 ? 12 : hour); }

inline char makeampm(int hour) 
{	return hour < 12 ? 'a' : 'p'; }

class DispTime	: public TimeZone {
protected:
	char ampm;
public:
	DispTime(int hr, int min, int sec, timezone zn) 
			: TimeZone(adjust(hr), min, sec, zn)
		{ ampm = makeampm(hr); }
	void display()	{
		Time::display();
		cout << ' ' << ampm << 'm';
		cout << ' ' << TZ [zone];
	}
};

#endif
