// -------- strings.h

#ifndef STRINGS
#define STRINGS

#include <iostream.h>
#include <string.h>

class String    {
    char *sptr;
    void putstr(char *s);
public:
    // ------- CONSTRUCTORS 

    // -------- construct a null string
    String() { sptr = NULL; }
    // ------- construct with a char * initializer
    String(char *s);
    // ------- construct with another string as initializer
    String(String& s);
    // -------- construct with just a size
    String(int len);

    // ------- DESTRUCTOR

    ~String() { if (sptr != NULL) delete sptr; }

    // ------- MEMBER FUNCTIONS

    // ------ return the address of the string
    operator char* () { return sptr; }
    // ------ return the length of a string
    int length() { return strlen(sptr)+1; }



    // ------- SUBSTRINGS

    // ---- substring: right len chars
    String right(int len);
    // ---- substring: left len chars
    String left(int len);
    // ---- substring: middle len chars starting from where
    String mid(int len, int where);

    // ------- ASSIGNMENTS

    // -------- assign a char array to a string
    String& operator=(char *s);
    // ---------- assign a string to a string
    String& operator=(String& s) { return *this = s.sptr;}

    // ------- CONCATENATORS

    // --- 1st concatenation operator (str1 += char *)
    String& operator+=(char *s);
    // --- 2nd concatenation operator (str1 += str2;)
    String& operator+=(String& s) 
		{ return *this += s.sptr;}
    // --- 3rd concatenation operator (str1 = str2+char*;)
    String operator+(char *s);
    // --- 4th concatenation operator (str1 = str2+str3;)
    String& operator+(String& s) { return *this + s.sptr; }
    // --- 5th concatenation operator (str1 = char* +str2;)
    friend String operator+(char *s, String& s1);

    // ------- RELATIONAL OPERATORS
    int operator==(String& s) 
        { return strcmp(sptr,s.sptr)==0;}
    int operator!=(String& s) 
        { return strcmp(sptr,s.sptr)!=0;}
    int operator<(String& s)  
        { return strcmp(sptr,s.sptr)< 0;}
    int operator>(String& s)  
        { return strcmp(sptr,s.sptr)> 0;}

    int operator<=(String& s) 
        { return strcmp(sptr,s.sptr)<=0;}
    int operator>=(String& s) 
        { return strcmp(sptr,s.sptr)>=0;}
    int operator==(char *s)   
        { return strcmp(sptr,s)==0; }
    int operator!=(char *s)   
        { return strcmp(sptr,s)!=0; }
    int operator<(char *s)      
        { return strcmp(sptr,s)< 0; }
    int operator>(char *s)      
        { return strcmp(sptr,s)> 0; }
    int operator<=(char *s)   
        { return strcmp(sptr,s)<=0; }
    int operator>=(char *s)   
        { return strcmp(sptr,s)>=0; }
    friend int operator==(char *s, String& st)
        { return st == s; }
    friend int operator!=(char *s, String& st)
        { return st != s; }
    friend int operator<(char *s, String& st)
        { return st > s; }
    friend int operator>(char *s, String& st)
        { return st < s; }
    friend int operator<=(char *s, String& st)
        { return st >= s; }
    friend int operator>=(char *s, String& st)
        { return st <= s; }

    // ------- SUBSCRIPTOR
    char& operator[](int n) { return *(sptr + n); }

    // ------- STREAM OPERATORS
    friend ostream& operator<<(ostream& os, String& st);
    friend istream& operator>>(istream& is, String& st);
};

#endif
