// ex09016
// An organization's class structure
// ------------ org.h

#ifndef COMPANY_H
#define COMPANY_H

#include <iostream.h>
#include <string.h>

class OrgEntity {
	char name[25];
	int employee_count;
public:
	OrgEntity(char *s, int ec) 
		{ strcpy(name, s); employee_count = ec; }
	int number_employees() { return employee_count; }
	char *org_name() { return name; }
	virtual int office_party() = 0;
};

class Company : public OrgEntity	{
public:
	Company(char *s, int ec) : OrgEntity(s, ec) { }
	virtual int office_party() { return 100; }
};

class Division : public Company	{
public:
	Division(char *s, int ec) : Company(s, ec) { }
	virtual int office_party() { return 75; }
};

class Department : public Division	{
public:
	Department(char *s, int ec) : Division(s, ec) { }
	virtual int office_party() { return 50; }
};

#endif
