// ex09020.cpp
// Multiple inheritance
#include <iostream.h>
#include <string.h>


// ------ base Time class
class Time {
protected:
	int hours, minutes, seconds;
public:
	Time(int h, int m, int s)
		{ hours = h; minutes = m; seconds = s; }
	virtual void display()
		{ cout << hours << ':' << minutes << ':' << seconds; }
};


// ------ base Date class
class Date {
protected:
	int month, day, year;
public:
	Date(int m, int d, int y)
		{ month = m; day = d; year = y; }
	virtual void display()
		{ cout << month << '/' << day << '/' << year; }
};


// ------ derived FileStamp class
class FileStamp : public Time, public Date	{
protected:
	char filename[15];
public:
	FileStamp(char *fn, int mm, int dd, int yy,
						int hr, int mn, int sc)
				: Time(hr, mn, sc), Date(mm, dd, yy)
		{ strcpy(filename, fn); }
	void display();
};


// ----- the display function for the derived class
void FileStamp::display()
{
	cout << filename << ' ';
	Date::display();
	cout << ' ';
	Time::display();
}

main()
{
	FileStamp fs("DATAFILE", 4, 6, 90, 13, 32, 27);
	fs.Date::display();
}
