// ex07017.cpp
// Destructors
#include <iostream.h>
#include <string.h>

// ------- date class
class Date {
	int mo, da, yr;
	char *month;
public:
	Date();
	Date(int m, int d, int y);
	~Date();
	void display();
};

// constructor that is called for an uninitialized Date
Date::Date()
{
	mo = 0; da = 0; yr = 0;
	month = NULL;	
}

// constructor that is called for an initialized Date
Date::Date(int m, int d, int y)
{
	static char *mos[] = {
		"January", "February", "March", "April", "May", 
		"June",	"July", "August", "September", "October", 
		"November",	"December"
	};
	mo = m; da = d; yr = y;
	month = new char[strlen(mos[m-1])+1];
	strcpy(month, mos[m-1]);
}

// Destructor for a Date
Date::~Date()
{
	if (month != NULL)
		delete month;
}

// ----------- display member function
void Date::display() 
{
	if (month != NULL)
		cout << '\n' << month << ' ' << da << ", " 
			 << yr+1900;
}

main()
{
	Date birthday(6,24,40);
	birthday.display();
}
