// ex07012.cpp
// Conversions with proper data hiding
#include <iostream.h>

// -------- Julian date class
class Julian {
	int da, yr;
public:
	Julian() {}
	Julian(int d, int y) { da = d; yr = y;}
	void display(){cout << '\n' << yr << '-' << da;}
	// ------ member function to read and write a day
	int& day() { return da; }
};

// ------- date class
class Date {
	int mo, da, yr;
public:
	Date(int m, int d, int y) { mo = m; da = d; yr = y; }
	operator Julian(); // conversion function
};

static int dys[] = {31,28,31,30,31,30,31,31,30,31,30,31};
// ---- member conversion function (Julian <- Date)
Date::operator Julian()
{
	Julian jd(0, yr);
	for (int i = 0; i < mo-1; i++)
		jd.day() += dys[i];		// uses member function to
	jd.day() += da;				// change da in Julian class
	return jd;
}

main()
{
	Date dt(11,17,89);
	Julian jd;
	// ------- convert Date to Julian via assignment
	jd = dt;
	jd.display();
}
