// ex07008.cpp
// Invoking conversions
#include <iostream.h>

// -------- Julian date class
class Julian {
public:
	int da, yr;
	Julian() {}
	Julian(int d, int y) { da = d; yr = y;}
	void display(){cout << '\n' << yr << '-' << da;}
};

// ------- date class
class Date {
	int mo, da, yr;
public:
	Date(int m, int d, int y) { mo = m; da = d; yr = y; }
	operator Julian(); // conversion function
};

static int dys[] = {31,28,31,30,31,30,31,31,30,31,30,31};

// ---- member conversion function (Julian <- Date)
Date::operator Julian()
{
	Julian jd(0, yr);
	for (int i = 0; i < mo-1; i++)
		jd.da += dys[i];
	jd.da += da;
	return jd;
}

main()
{
	Date dt(11,17,89);
	Julian jd;
	// ------- convert Date to Julian via implicit conversion
	jd = dt;
	jd.display();
	// ------- convert Date to Julian via cast
	jd = (Julian) dt;
	jd.display();
	// ------- convert Date to Julian via reverse cast
	jd = Julian(dt);
	jd.display();
}
