// ex09005
// Header to define derived DispTime class
// ---------- disptime.h

#ifndef DISPTIME_H
#define DISPTIME_H

#include <stdio.h>
#include "timezone.h"

//
// A DispTime Class
//

inline int adjust(int hour)
{	return hour > 12 ? hour - 12 : (hour == 0 ? 12 : hour); }

inline char makeampm(int hour) 
{	return hour < 12 ? 'a' : 'p'; }

class DispTime	: public TimeZone {
protected:
	char ampm;
public:
	DispTime(int hr, int min, int sec, timezone zn) 
			: TimeZone(adjust(hr), min, sec, zn)
		{ ampm = makeampm(hr); }
	void display()	{
		Time::display();
		cout << ' ' << ampm << 'm';
		cout << ' ' << TZ [zone];
	}
};

#endif
